@php
$users = DB::table('users')->where('id','!=', Auth::user()->id)->get();
$friendsData = DB::table('friends')->where('user_id', Auth::user()->id)->whereIn('is_accept', [0, 1])->get();
//<span class="{{ $items->isOnline() ? 'online' : 'offline' }}">.</span>
@endphp
<style>
    .uTab {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 10px;
        background: linear-gradient(135deg, #ff9999, #ff66cc); /* Radient background color */
        border-radius: 20px;
        box-shadow: 0px 3px 6px rgba(0, 0, 0, 0.1);
    }

    .uTab img {
        width: 45px;
        height: 45px;
        border-radius: 50%;
        object-fit: cover;
    }

    .uTab h6 {
        margin: 0;
        font-size: 16px;
        color: #fff;
    }

    .uTab span {
        font-size: 12px;
        color: #fff;
    }

    .btns button {
        width: 30px;
        height: 30px;
        background: #4caf50;
        border: none;
        border-radius: 50%;
        cursor: pointer;
        transition: background 0.3s ease-in-out;
    }

    .btns button:hover {
        background: #388e3c;
    }

    .btns button i {
        color: #fff;
    }
</style>
<div class="col-md-3">
    <div class="sidebarLeft side-ri friends-list">
        <div class="search-user">
                <div class="form-group">
                    <div class="input-group mb-3">
                        <input type="text" class="form-control srchUser" placeholder="Search User" name="search" id="srchUser">
                        <div class="input-group-append">
                            <button class="btn btn-outline-secondary" type="submit"><i class="fa-solid fa-magnifying-glass"></i></button>
                        </div>
                    </div>
                </div>
        </div>
        <div class="most d-flex justify-content-between">
        </div>
        <div class="user recent_users" id="friends-list">
            @foreach($users as $key => $items)
                @php
                    $friendship = $friendsData->where('friend_id', $items->id)->first();
                @endphp
                <div class="message user-{{ $items->id }} mb-3 uTab">
                    <div class="d-flex align-items-center">
                        <div class="mx-3">
                            @if($items->profile->pic)
                                <img src="{{ asset($items->profile->pic) }}" alt="{{ $items->name }}" class="img-fluid">
                            @else
                                <img src="{{ asset('images/userImage.jpg') }}" alt="{{ $items->name }}" class="img-fluid">
                            @endif
                        </div>
                        <div>
                            <h6>
                                <a href="{{ route('message', ['id' => $items->id]) }}" style="color: #fff; text-decoration: none;">{{ $items->name }} {{ $items->profile->lname }}</a>
                            </h6>
                            <span>{{ $items->email }}</span>
                        </div>
                    </div>
                    <div class="d-flex align-items-center justify-content-around btns">
                        @if($friendship)
                            <button class="rmFrnd" data-id="{{ $items->id }}"><i class="fa fa-times text-white"></i></button>
                        @else
                            <button class="addFrnd" data-id="{{ $items->id }}"><i class="fa fa-plus text-white"></i></button>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>


<script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>

<script>
    $(document).ready(function() {
        $(document).on('click', '.btn-outline-secondary', function () {
    var query = $('.srchUser').val().trim(); // Trim whitespace from the input value
    console.log('Search query:', query);
    
    // Perform the search only if the query is not empty
    if (query !== '') {
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $.ajax({
            type: "POST",
            url: '{{ route('search.friends') }}',
            data: {
                "_token": "{{ csrf_token() }}",
                "query": query,
            },
            dataType: "json",
            success: function (response) {
                var friendsList = $('#friends-list');

                if (response.length > 0) {
                    friendsList.empty();

                    $.each(response, function (index, user) {
                        var userHtml = `
                            <div class="message user-${user.id} mb-3 uTab">
                                <div class="d-flex align-items-center p-3">
                                    <div class="mx-3">
                                        ${user.profile.pic
                                            ? `<img src="${user.profile.pic}" width="45px" height="45px" class="img-fluid">`
                                            : `<img src="${asset('images/userImage.jpg')}" width="45px" height="45px" class="img-fluid">`
                                        }
                                    </div>
                                    <h6>
                                        <a href="${route('message', ['id' => user.id])}">
                                            ${user.name} ${user.profile.lname}
                                        </a>
                                        <span style="font-size: 10px;">${user.email}</span>
                                    </h6>
                                </div>
                                <div class="d-flex align-items-center justify-content-around btns">
                                    <div>
                                        ${friendship
                                            ? `<button class="rmFrnd bg-danger" data-id="${friendship.id}"><i class="fa fa-x text-white"></i></button>`
                                            : `<button class="addFrnd bg-primary" data-id="${user.id}"><i class="fa fa-plus text-white"></i></button>`
                                        }
                                    </div>
                                </div>
                            </div>`;
                        friendsList.append(userHtml);
                    });
                } else {
                    friendsList.html('<p>No user found.</p>');
                }
            },
            error: function (error) {
                console.error(error);
            }
        });
    } else {
        $('#friends-list').empty(); // Clear the friends list if the search query is empty
    }
});

    });
</script>
