@extends('layouts.main')

@section('css')
<style>
.profile{
  position: relative;
  top: 100px;
  bottom: auto;
  left: 0;
  right: 0;
  min-height: 100%;
  height: auto;
  width: 100%;
  margin: 20px auto;
  margin-bottom: 100px;
  background-color: #fff;
  border-top: 5px solid #ff7eae;
  border-radius: 0 0 5px 5px;
  box-shadow: 0 2.5px 5px #ccc;
}
.content{
  /* position: absolute; */
  min-height: 100%;
  height: 100%;
  width: 95%;
  margin: 2.5% auto;
  left: 0;
  right: 0;
  top: 0;
  bottom: 0;
  /*border: 1px solid #eee;*/
  /*background-color: yellow;*/
  overflow: hidden;
}
.short-info{
  position: relative;
  min-height: 100px;
  height: auto;
  width: 97.5%;
  margin: 1.5% auto;
  /*background-color: #f5f5f5;*/
  background-color: #fff;
  background-color: #f2ecee;
  /*border-top: 2px solid #39cb58;*/
  border-radius: 2.5px;
  /*box-shadow: inset 0 -1.5px #ddd;*/
}
.details{
  width: 97.5%;
  /*background-color: red;*/
  margin: 2.5px auto;
}
.tab-heads{
  color: #777;
  margin: 0 2.5px;
}
.tabs{
  height: 200px;
  width: 97.5%;
  margin: 0 auto;
  /* border-top: 2.5px solid #39cb58; */
  background-color: #f2ecee;
  border-radius: 2.5px;
  /* background-color: #f3f3f3; */
}
span.fa-envelope{
  position: absolute;
  top: 22%;
  left: 56%;
  color: #39cb58;
}
span.photo{
  position: relative;
  height: 80px;
  width: 80px;
  border-radius: 5px;
  margin: 10px 0 2.5px;
  display: block;
  top: 10%;
  left: 10%;
  overflow: hidden;
  background: #ddd url("https://www.adtechnology.co.uk/images/UGM-default-user.png");
  background-size: 100%;
  border-radius: 100%;
  border: 2px solid #ddd;
}
span.photo:after{
  content: " Add Profile Pic ";
  text-align: center;
  position: absolute;
  left: 0;
  z-index: 2;
  padding: 35% 0 65%;
  height: 0;
  width: 100%;
  opacity: 0;
  color: #222;
  background-color: rgba(0,0,0,0.25);
  background-size: 100%;
  transition: 0.35s ease-in-out;
  overflow: hidden;
  border-radius: 100%;
}
span.photo:hover:after{
  bottom: 0;
  opacity: 1;
  color: #fff;
}
input[type="file"]{
  /* position: absolute; */
  color: #555;
  font-size: 15px;
  top: 25%;
  box-shadow: none !important;
  margin-left:  !important;
  background-color: #ededed;
  width: 200px;
  border: 0;
}

span.name,span.links > h3,h4{
  font-family: Lato;
  /*font-weight: 200;*/
}
span.name{
  position: absolute;
  top: 20%;
  left: 25%;
  color: #555;
  font-size: 18px;
}
label{
  color: #555;
  line-height: 2.1em;
  margin-left: 10px;
}
label[for="avatar"]{
  line-height: 120px;
}
.btn{
  /* position: absolute; */
  top: 45%;
  left: 25%;
  /* color: #fff; */
  /* background-color: rgba(57,203,88,0.65); */
  background-color: #ddd;
  padding: 10px 15px;
  border-radius: 3px;
  box-shadow: inset 0 0 0 2px #39cb58,
              0 2px 0 0 rgba(57,203,88,0.5);
  cursor: pointer;
  transition: 0.5s ease;
}
span.btn:hover{
  opacity: 1;
  color: #fff;
  background-color: rgba(57,203,88,1);
  /* background-color: #39cb58; */
}
.profile:hover .btn{
    opacity: 1;
}
.short-info span h3,h4{
  display: inline-block;
  margin: 0;
}

div.circles{
  width: 100%;
  margin: 0 auto;
}
span.fa-users{
  color: #777;
  margin-left: 1px;
  margin: 7px 7px 2.5px;
}
span.fa-users:after{
  content: "Circles";
  font-family: Lato;
  margin-left: 3px;
  color: #777;
}
.myCircle{
  height: 200px;
  width: 97.5%;
  margin: 0 auto;
  background-color: #f2ecee;
  border-radius: 2.5px;
}

/*Circles Styles
=========================*/
.myCircle #tabs ul li:nth-child(1){
  margin: 0;
  padding: 0px 5px 10px;
  /*margin-top: 5px;*/
  background-color: white;
  border-radius: 0 0 0 30px;
}
.myCircle #tabs ul li:nth-child(2){
  margin-left: -3px;
  padding: 0 5px 10px;
  border-radius: 0 0 30px 0;
  background-color: white;
}
.myCircle #tabs .active{
  border-bottom: none;
  padding-left: 10px;
}
.myCircle #tabs{
  padding: 0;
  margin: 0;
}
.fa-twitter,.fa-facebook,.fa-github{
  height: 20px;
  width: 20px;
  text-align: center;
  line-height: 20px;
  padding: 2.5px;
  margin-left: -15px;
}

/*Input Fields Styles
=========================*/
fieldset textarea,input{
  font-family: Open Sans;
  font-size: 15px;
  color: #333;
  background-color: #f7f7f7;
  box-shadow: 0 0 0 1px #ff7eae;
  padding: 5px;
  width: 75%;
  margin: 5px auto;
  border: 0;
  border-radius: 2.5px;
  outline: 0;
  transition: 0.3s ease;
}
fieldset textarea{
  min-height: 40px;
  max-height: 60px;
}
fieldset textarea:hover,input:hover{
  box-shadow:0 0 0 1px #004c7f;
  background-color: #fff;
}
fieldset textarea:focus,input:focus{
  box-shadow: 0 0 0 1px #004c7f,
              inset 0 2px 5px -1px rgba(0,0,0,0.25);
}

.grid-35{
  width: 35%;
  float: left;
  font-weight: 500;
  color: #333;
  /* text-align: left; */
}
.grid-65{
  position: relative;
  width: 65%;
  float: right;
  font-family: Source Sans Pro;
  font-weight: 300;
  font-size: 17px;
}
#tabs-1 div,#tabs-2 div,#tabs-3 div{
  border-bottom: 1px solid #ddd;
}

/*Tabs Styles
=========================*/
#tabs {
  width: 97.5%;
  margin: 0 auto;
  position: relative;
  -webkit-transition: all 0.5s ease;
  -moz-transition: all 0.5s ease;
    transition: all 0.5s ease;
}
#tabs-1,#tabs-2,#tabs-3{
  width: 95%;
  margin: 0 auto;
  /*margin-top: 5px;*/
  padding: 5px 10px;
  line-height: 1.3em;
  padding-bottom: 10px;
  font-family: Open Sans;
  background-color: #f2ecee;
  border-radius: 0 2.5px 2.5px 2.5px;
  -webkit-transition: all 0.5s ease;
  -moz-transition: all 0.5s ease;
  transition: all 0.5s ease;
} 
#tabs ul{
  margin: 0 auto;
  padding: 0;
}
#tabs ul li{
  display: inline-block;
  margin: 0;
  padding: 0 7px;
  width: 65px;
  text-align: center;
  padding-bottom: 5px;
  -webkit-transition: all 0.5s ease;
  -moz-transition: all 0.5s ease;
     transition: all 0.5s ease;  
}
#tabs ul li a{
  outline: 0;
  text-decoration: none;
  padding: 0 3px 0 0;
  /* background-color: #222; */
  font-family: Open Sans;
  margin: 0;
  -webkit-transition: all 0.5s ease;
  -moz-transition: all 0.5s ease;
     transition: all 0.5s ease;
}

.ui-state-hover{
  border-bottom: 2.5px solid #aaa;
}
.ui-state-active{
  color: #38cc85;
  border-bottom: 2.5px solid #39cb58;
}

/* #CLEARFIX HACK
=========================*/
.clear:after{
  content: " ";
  display: table;
  clear: both;
}

/* Edit View
======================*/
.content h1{
  text-align: center;
  color: #555;
  font-family: Lato;
  font-size: 40px;
  font-weight: 200;
  margin: 5px auto 15px auto;
}
select{
  width: 80%;
  padding: 7px 10px;
  background-color: #f5f5f5;
  border:1px solid #ff7eae;
  border-radius: 2.5px;
  outline: 0;
}
select option{
  padding: 5px;
}
fieldset{
  text-align: center;
  /* background-color: rgba(0,0,0,0.01); */
  margin-bottom: 5px;
  padding: 5px;
  box-sizing: border-box;
  border-bottom: 1px solid rgba(0,0,0,0.07);
}
fieldset:last-child{
  border-bottom: none;
}
input.Btn {
    width: 48%;
    float: left;
    display: block;
    margin: 40px auto;
    margin-left: 1%;
    padding: 15px 0;
    font-size: 16px;
    color: #fff;
    cursor: pointer;
    background-color: rgb(255 126 174 / 70%);
    box-shadow: inset 0 0 0 2px #ff7eae94, 0 2px 0 0 rgb(255 126 174 / 53%);
    transition: 0.5s ease;
}
input.Btn:hover{
  background-color: rgb(255 126 174);
}

/* Header Bar 
===========================*/
.navbar{
  padding: 10px;
  box-shadow: 0 2.5px 10px rgba(0,0,0,0.5);
}
div.logo{
/*    margin: 0 auto;*/
/*    text-align: center;*/
    font-size: 30px;
    font-family:"Source Sans Pro";
    color:#39cb58;
    width: 100%;
/*    display: inline-block;*/
    /*    position: absolute;*/
/*    top:0px;*/
/*    left:0;*/
    right: 0;
    z-index: 2;
}
span.logo-part{
    color:#fff;
    background-color: #39cb58;
    padding: 2px 5.5px 0px 10px;
    border-radius:100%;
    margin-bottom:15px;
    font-family: "Montez";
}
.search{
/*    margin-top:5px;
/*    border:0;*/
    float: left;
    position: relative;
    top:4px;
    right: 100px;
    padding-bottom: 0;
}
.search-bar{
/*    border:0;*/
    width:220px;
    color:white;
    background-color:#eee;
    font-family: "Lato","Open Sans",Helvetica,Arial;
    border-top: 2px solid black;
    padding: 5px;
    padding-left: 15px;
    display: inline;
    border-radius: 50px;
    -webkit-transition: 0.4s ease;
                transition: 0.4s ease;
}
.search-icon{
    color:gray;
    margin-left:-27.5px;
}
.search-bar:focus{
    width:255px;
    outline:none;
}
.navbar-nav li a{
  padding-left: 8.5px;
  padding-right: 8.5px;
  font-size: 12px;
  transition: 0.5s ease;
}
.navbar-nav li a > span.fa:before{
  margin-right: 5px;
  /* background-color: #ddd; */
}

/*//Avatar Upload*/
.avatar-upload {
  position: relative;
  max-width: 205px;
  margin: 50px auto;
}
.avatar-upload .avatar-edit {
  position: absolute;
  right: 12px;
  z-index: 1;
  top: 10px;
}
.avatar-upload .avatar-edit input {
  display: none;
}
.avatar-upload .avatar-edit input + label {
  display: inline-block;
  width: 34px;
  height: 34px;
  margin-bottom: 0;
  border-radius: 100%;
  background: #FFFFFF;
  border: 1px solid transparent;
  box-shadow: 0px 2px 4px 0px rgba(0, 0, 0, 0.12);
  cursor: pointer;
  font-weight: normal;
  transition: all 0.2s ease-in-out;
}
.avatar-upload .avatar-edit input + label:hover {
  background: #f1f1f1;
  border-color: #d6d6d6;
}
.avatar-upload .avatar-edit input + label:after {
  content: "\f040";
  font-family: 'FontAwesome';
  color: #757575;
  position: absolute;
  top: 2px;
  left: 10px;
  right: 0;
  text-align: center;
  margin: auto;
}
.avatar-upload .avatar-preview {
  width: 192px;
  height: 192px;
  position: relative;
  border-radius: 100%;
  border: 6px solid #F8F8F8;
  box-shadow: 0px 2px 4px 0px rgba(0, 0, 0, 0.1);
}
.avatar-upload .avatar-preview > div {
  width: 100%;
  height: 100%;
  border-radius: 100%;
  background-size: cover;
  background-repeat: no-repeat;
  background-position: center;
}
</style>

@endsection
@section('content')

<section class="home-sec1">
    <div class="container-fluid">
        <div class="row">
            <!--Recent Post-->
            @include('account.post')
            <div class="col-md-6">
                <div class="center-bar">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" id="my-trips-tab"  href="{{route('account')}}"  >Back To Posts</a>
                            </li>
                            
                    </ul>
                </div>
                <div class="wrapper">
                    <div class="profile">
                        <div class="content">
                                <h1>Edit Profile</h1>
                                <form action="{{ route('uploadPicture') }}" method="post" enctype="multipart/form-data" id="accountForm">
                                    <!-- Photo -->
                                    @csrf
                                    <fieldset>
                                        <div class="avatar-upload">
                                            <div class="avatar-edit">
                                                <input type="file" name="profilePhoto" id="imageUpload" accept=".png, .jpg, .jpeg" />
                                                <label for="imageUpload"></label>
                                            </div>
                                            <div class="avatar-preview">
                                                @if(Auth::user()->profile->pic != '')
                                                <div id="imagePreview" style="background-image: url({{asset(Auth::user()->profile->pic)}});"></div>
                                                @else
                                                <div id="imagePreview" style="background-image: url('http://i.pravatar.cc/500?img=7');"></div>
                                                @endif
                                            </div>
                                        </div>
                                    </fieldset>
                                    <fieldset>
                                      <div class="grid-35">
                                        <label for="fname">First Name</label>
                                      </div>
                                      <div class="grid-65">
                                        <input type="text" name="fname" id="fname" tabindex="1" value="{{Auth::user()->name}}" />
                                      </div>
                                    </fieldset>
                                    <fieldset>
                                      <div class="grid-35">
                                        <label for="lname">Last Name</label>
                                      </div>
                                      <div class="grid-65">
                                        <input type="text" name="lname" id="lname" tabindex="2" value="{{Auth::user()->profile->lname}}" />
                                      </div>
                                    </fieldset>
                                    <!-- Description about User -->
                                    <fieldset>
                                      <div class="grid-35">
                                        <label for="description">About you</label>
                                      </div>
                                      <div class="grid-65">
                                        <textarea  name="personalDetail" cols="30" rows="auto" tabindex="3">{{Auth::user()->profile->bio}}</textarea>
                                      </div>
                                    </fieldset>
                                    <!-- Country -->
                                    <fieldset>
                                      <div class="grid-35">
                                        <label for="country">Country</label>
                                      </div>
                                      <div class="grid-65">
                                        <input type="text" name="country" id="country" tabindex="5" value="{{Auth::user()->profile->country}}"/>
                                      </div>
                                    </fieldset>
                                    <!-- Email -->
                                    <fieldset>
                                      <div class="grid-35">
                                        <label for="email">Email Address</label>
                                      </div>
                                      <div class="grid-65">
                                        <input type="email" name="email" id="email" tabindex="6" value="{{Auth::user()->email}}" />
                                      </div>
                                    </fieldset>
                                    <!-- Highest Qualification -->
                                    <fieldset>
                                      <div class="grid-35">
                                        <label for="qualification">Highest level of Education</label>
                                      </div>
                                      <div class="grid-65">
                                        <select name="qualification" id="qualification" tabindex="8">
                                          <option selected="selected" value="--------------" disabled>--------------</option>
                                          <option value="primary_school" {{(Auth::user()->profile->qualification == "primary_school") ? "selected" : ""}}>Primary school or equivalent</option>
                                          <option value="high_school" {{(Auth::user()->profile->qualification == "high_school") ? "selected" : ""}}>High school or equivalent</option>
                                          <option value="associate" {{(Auth::user()->profile->qualification == "associate") ? "selected" : ""}}>Associate degree or equivalent</option>
                                          <option value="bachelors" {{(Auth::user()->profile->qualification == "bachelors") ? "selected" : ""}}>Bachelor's degree or equivalent</option>
                                          <option value="post_graduate" {{(Auth::user()->profile->qualification == "post_graduate") ? "selected" : ""}}>Post-graduate or equivalent</option>
                                        </select>
                                      </div>
                                    </fieldset>
                                    <!-- Linkedin URL -->
                                    <fieldset>
                                      <div class="grid-35">
                                        <label for="linkedin">Facebook URL</label>
                                      </div>
                                      <div class="grid-65">
                                        <input type="text" name="facebook" id="facebook" tabindex="12" value="{{Auth::user()->profile->facebook}}" />
                                      </div>
                                    </fieldset>
                                    <!-- Github URL -->
                                    <fieldset>
                                      <div class="grid-35">
                                        <label for="github">Twitter URL</label>
                                      </div>
                                      <div class="grid-65">
                                        <input type="text" name="twitter" id="github" tabindex="13" value="{{Auth::user()->profile->twitter}}"  />
                                      </div>
                                    </fieldset>
                                    <!-- Website URL -->
                                    <fieldset style="border-bottom: none;">
                                      <div class="grid-35">
                                        <label for="website">Instagram URL</label>
                                      </div>
                                      <div class="grid-65">
                                        <input type="text" name="instagram" id="website" tabindex="13"  value="{{Auth::user()->profile->instagram}}" />
                                      </div>
                                    </fieldset>
                                    <fieldset>
                                      <input type="button" class="Btn cancel" value="Cancel" />
                                      <input type="submit" class="Btn" value="Save Changes" />
                                    </fieldset>
                                    
                                </form>
                        </div>
                    </div>
                </div>
            </div>
            <!--Online Friends-->
            @include('account.friends')
        </div>
    </div>
</section>

@endsection
@section('js')
<script>
function readURL(input) {
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        reader.onload = function(e) {
            $('#imagePreview').css('background-image', 'url('+e.target.result +')');
            $('#imagePreview').hide();
            $('#imagePreview').fadeIn(650);
        }
        reader.readAsDataURL(input.files[0]);
    }
}
$("#imageUpload").change(function() {
    readURL(this);
});
</script>

@endsection