@extends('layouts.main')

@section('css')
    <link rel="stylesheet" href="{{ asset('css/trip-taken.css') }}">
    <link rel="stylesheet" href="{{ asset('css/chatbox.css') }}">
    <!--<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/fancybox@3.5.7/dist/jquery.fancybox.min.css">-->

    <style>
        .nav.flex-column {
            background-color: transparent;
            border-radius: 0;
            width: 100%;
            padding: 0;
        }

        .date {
            text-decoration: none !important;
        }

        .trip-right p strong {
            text-decoration: none !important;
        }

        .Bottom-footer {
            position: relative;
            padding-top: 1rem;
            padding-bottom: 1rem;
            background: #ff7eae;
        }

        .trip-taken-head {

            color: #f587ac;
            font-size: 120px;
            font-weight: 500;
            font-family: Mishella;
            text-align: center;
        }
        .side-ri{
            display: none;
        }
        .search-user .form-group input{
            padding: 10px;
            background: #5f9ea04d;
            color: white;
            border: 1px solid #8b00005e;
            border-radius: 12px;
        }
    
                            .btns button {
                                width: 50px;
                                height: 25px;
                                background: brown;
                                border-radius: 20px;
                                cursor: pointer;
                            }

                            .uTab {
                                display: flex;
                                align-items: center;
                                justify-content: space-between;
                                padding: 5px;
                                background: #e2dde3;
                                border-radius: 10px;
                                box-shadow: 2px 5px 10px grey;
                            }
                        </style>
@endsection

@section('content')
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"
        integrity="sha256-2Pmvv0kuTBOenSvLm6bvfBSSHrUJ+3A7x6P5Ebd07/g=" crossorigin="anonymous"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.0.1/css/toastr.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.0.1/js/toastr.js"></script>

    <script>
        $(document).ready(function() {
            toastr.options.timeOut = 10000;

            @if (Session::has('success'))
                toastr.success('{{ Session::get('success') }}');
            @endif

            @if (Session::has('info'))
                toastr.info('{{ Session::get('info') }}');
            @endif

            @if (Session::has('warning'))
                toastr.warning('{{ Session::get('warning') }}');
            @endif

            @if (Session::has('error'))
                toastr.error('{{ Session::get('error') }}');
            @endif
        });
    </script>
    <section class="home-sec1">
        <div class="container-fluid">
            <div class="row">
                <!--Recent Post-->
                @include('account.post')
                <div class="col-md-6">
                    <div class="friends-list" style="margin-top: 100px;">
                        <div class="search-user">
                            <div class="form-group">
                                <div class="input-group mb-3">
                                    <input type="text" class="form-control" placeholder="Search User" name="search"
                                        id="srchUser">
                                </div>
                            </div>
                        </div>
                        
                        <div class="most d-flex justify-content-between">
                        </div>
                        @php
                            $users = DB::table('users')
                                ->where('id', '!=', Auth::user()->id)
                                ->get();
                        
                            $messages = DB::table('message')
                                ->where('sender_id', Auth::user()->id)
                                ->orWhere('reciever_id', Auth::user()->id)
                                ->get();
                        @endphp
                        
                        <div class="user recent_users" id="friends-list">
                            @foreach ($users as $key => $user)
                                @php
                                    $userMessages = $messages->filter(function ($message) use ($user) {
                                        return $message->sender_id == $user->id || $message->reciever_id == $user->id;
                                    });
                                    $hasChat = $userMessages->isNotEmpty();
                                    $lastMessage = $userMessages->last();
                                @endphp
                        
                                @if ($hasChat)
                                <a href="{{ route('message', ['id' => $user->id]) }}">
                                    <div class="message user-{{ $user->id }} mb-3 uTab">
                                        <div class="d-flex align-items-center p-3">
                                            <div class="mx-3">
                                                @if ($user->profile->pic)
                                                    <img src="{{ asset($user->profile->pic) }}" width="45px" height="45px" class="img-fluid">
                                                @else
                                                    <img src="{{ asset('images/userImage.jpg') }}" width="45px" height="45px" class="img-fluid">
                                                @endif
                                            </div>
                                            <h6>
                                                {{ $user->name }} {{ $user->profile->lname }}
                                                <span style="font-size: 10px; margin-top: 10px;">
                                                    @if ($lastMessage)
                                                        <p style="font-size: 10px; margin-top: 10px;">{{ $lastMessage->message }}</p>
                                                    @else
                                                        <p>No messages yet</p>
                                                    @endif
                                                </span>
                                            </h6>
                                        </div>
                                    </div>
                                </a>
                                @endif
                            @endforeach
                        </div>


                    </div>
                </div>

                <!-- Include jQuery first -->
                <script src="https://code.jquery.com/jquery-3.7.1.min.js"
                    integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>

                <!-- Include toastr CSS and JS files -->
                <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css">
                <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>

                <script>
                    $(document).ready(function() {
                        var isRequestInProgress = false;

                        $('.addFrnd, .rmFrnd').click(function() {
                            // Check if a request is already in progress
                            if (isRequestInProgress) {
                                return;
                            }
                            // Set the flag to indicate that a request is in progress
                            isRequestInProgress = true;
                            // Disable the button to prevent multiple clicks
                            $(this).prop('disabled', true);
                            var friendId = $(this).data('id');
                            var csrfToken = $('meta[name="csrf-token"]').attr('content');
                            $.ajax({
                                url: "{{ route('friendship.post') }}",
                                type: "POST",
                                data: {
                                    "_token": csrfToken,
                                    friendId: friendId,
                                },
                                headers: {
                                    'X-CSRF-TOKEN': csrfToken
                                },
                                success: function(response) {
                                    console.log(response);
                                    if (response.success) {
                                        toastr.success(response.message);
                                        window.location.reload();
                                    } else {
                                        toastr.error(response.message);
                                    }
                                },
                                error: function(xhr, status, error) {
                                    console.log('XHR Status:', status);
                                    console.log('XHR Error:', error);
                                    console.log('XHR Response:', xhr.responseText);
                                    toastr.error(
                                        'Error processing request. Please check the console for more details.'
                                        );
                                },
                                complete: function() {
                                    // Re-enable the button and reset the flag after the request is complete
                                    $('.addFrnd, .rmFrnd').prop('disabled', false);
                                    isRequestInProgress = false;
                                }
                            });
                        });


                        // search friend
                        $('#srchUser').on('input', function() {
                            var query = $(this).val();
                            console.log(query);
                            $.ajaxSetup({
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                }
                            });

                            $.ajax({
                                type: "POST",
                                url: '{{ route('search.friends') }}',
                                data: {
                                    "_token": "{{ csrf_token() }}",
                                    "query": query,
                                },
                                dataType: "json",
                                success: function(response) {
                                    var friendsList = $('#friends-list');

                                    if (response.length > 0) {
                                        friendsList.empty();

                                        $.each(response, function(index, user) {
                                            var userHtml = `
                                <div class="message user-${user.id} mb-3 uTab">
                                    <div class="d-flex align-items-center p-3">
                                        <div class="mx-3">
                                            ${user.profile.pic
                                                ? `<img src="${user.profile.pic}" width="45px" height="45px" class="img-fluid">`
                                                : `<img src="${asset('images/userImage.jpg')}" width="45px" height="45px" class="img-fluid">`
                                            }
                                        </div>
                                        <h6>
                                            <a href="${route('message', ['id' => user.id])}">
                                                ${user.name} ${user.profile.lname}
                                            </a>
                                            <span style="font-size: 10px;">${user.email}</span>
                                        </h6>
                                    </div>
                                    <div class="d-flex align-items-center justify-content-around btns">
                                        <div>
                                            ${friendship
                                                ? `<button class="rmFrnd bg-danger" data-id="${friendship.id}"><i class="fa fa-x text-white"></i></button>`
                                                : `<button class="addFrnd bg-primary" data-id="${user.id}"><i class="fa fa-plus text-white"></i></button>`
                                            }
                                        </div>
                                    </div>
                                </div>`;
                                            friendsList.append(userHtml);
                                        });
                                    } else {
                                        friendsList.html('<p>No user found.</p>');
                                    }
                                },
                                error: function(error) {
                                    console.error(error);
                                }
                            });
                        });

                        // function generateUserCard(user, profile) {
                        //     var cardHtml = `
        //         <div class="message user-${user.id} mb-3 uTab">
        //             <div class="d-flex align-items-center p-3">
        //                 <div class="mx-3">
        //                     ${profile.pic ? `<img src="asset(${profile.pic})" width="45px" height="45px" class="img-fluid">` :
        //                     `<img src="{{ asset('images/userImage.jpg') }}" width="45px" height="45px" class="img-fluid">`}
        //                 </div>
        //                 <h6>
        //                     <a href="{{ route('message', ['id' => '${user.id}']) }">${user.name} ${profile.lname}</a>
        //                     <span style="font-size: 10px;">${user.email}</span>
        //                 </h6>
        //             </div>
        //             <div class="d-flex align-items-center justify-content-around btns">
        //                 <div>
        //                     ${user.friendship ? `<button class="rmFrnd bg-danger" data-id="${user.id}"><i class="fa fa-x text-white"></i></button>` : `<button class="addFrnd bg-primary" data-id="${user.id}"><i class="fa fa-plus text-white"></i></button>`}
        //                 </div>
        //             </div>
        //         </div>
        //     `;

                        //     return cardHtml;
                        // }


                    });
                </script>

                @include('account.chatbox')
                <!--Online Friends-->
                @include('account.friends')
            </div>
        </div>
    </section>



    <!-- contact foam end  -->

    <!--@include('layouts/front.footer')-->
@endsection
@section('js')
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
        integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script>
        $(document).ready(function() {

            function handleFormSubmission(formId, isFeaturedValue) {
                var form = $(formId);
                form.find('.loader').show();

                var formData = new FormData(form[0]);

                $.ajax({
                    url: form.attr('action'),
                    method: "POST",
                    data: formData,
                    dataType: 'JSON',
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function(data) {
                        form.find('.loader').hide();
                        if (data.status) {
                            form.find('.success-msg').addClass('alert alert-success');
                            form.find('.success-msg').html(data.message);
                        } else {
                            form.find('.error-msg').addClass('alert alert-danger');
                            form.find('.error-msg').html('Please Contact Administrator');
                        }

                        form[0].reset();
                        form.find('.dropify-clear').click();
                    }
                });
            }

            $('.btn-exist').click(function() {
                $('.isFeatured-value').val(2);
                // handleFormSubmission('#save-trip-form-post');
            });

            $('.btn-future').click(function() {
                $('.isFeatured-value').val(1);
                // handleFormSubmission('#save-trip-form-post');
            });

            // $('#new-trip-form-post').on('submit', function(event) {
            //     event.preventDefault();
            //     handleFormSubmission('#new-trip-form-post');
            // });

            // $('#save-trip-form-post').on('submit', function(event) {
            //     event.preventDefault();
            //     handleFormSubmission('#save-trip-form-post');
            // });

        });
    </script>
@endsection
