@extends('layouts.main')
@section('content')

<style>
    .section{
            width: 100%;
    height: 100vh;
    background: black;
    display: flex;
    align-items: center;
    }
    
    .videoBox1{
            width: 100%;
    height: 500px;
    position: relative;
    }
    .videoBox1 video {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        object-fit: cover;
    }
    .notifyBtn {
    width: 170px;
    height: 170px;
    background: red;
    border-radius: 50%;
    cursor: pointer;
    position: absolute;
    bottom: 10px;
    left: 20%; /* Initial position */
    transform: translateX(-50%);
    transition: transform 0.3s ease; /* Smooth transition */
}

.notifyBtn button {
    width: 100%;
    height: 100%;
    border-radius: 50%;
    cursor: pointer;
    color: black;
    font-weight: bold;
}

.notifyBtn button:hover {
    background: red;
    color: white;
    font-weight: bold;
    cursor: pointer;
}
    .vidContnt h6{
        font-weight: bold;
        font-size: 14px;
        color: white;
        position: absolute;
        top: -30px;
    }
    .vidContnt h1{
        font-weight: bold;
    }
    .vidContnt p{
        font-size: 20px;
        font-weight: bold;
        margin-top: 35px;
    }
    
    .videoBox2{
            width: 100%;
    height: 400px;
    position: relative;
    }
    .videoBox2 video{
            position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .sideBar{
        width: 85px;
        height: 100vh;
        border-right: 1px solid grey;
        position: absolute;
        color: white;
        left: 0;
        z-index: 10;
    }
    .sideBar ul {
    list-style: none;
    padding: 0;
    margin: 0;
    display: flex;
    flex-direction: column;
    justify-content: space-between; /* Add space between items */
    height: 100%; /* Ensure full height of sidebar */
}

.sideBar li {
    transform: rotate(-90deg);
    margin: 80px 0;
    white-space: nowrap;
    font-weight: bold;
}
</style>

<section class="section">
    <div class="container-fluid">
        <div class="row align-items-center" style="padding: 0px 100px;">
            <div class="sideBar">
                <ul>
                    <li>Home</li>
                    <li>About</li>
                    <li>Contact</li>
                </ul>
            </div>
            <div class="col-lg-7 p-0">
                <div class="videoBox1">
                    <video autoplay muted loop>
                        <source src="{{ asset('truckertrip/2.mkv') }}" type="video/mp4">
                        Your browser does not support the video tag.
                    </video>
                    <div class="vidContnt p-4">
                        <h6 class="fw-bold">We Are</h6>
                        <h1 class="fw-bold" id="animatedText" style="font-size: 60px;"></h1>
                        <p>
                            Our website is under construction. We are working very hard to give you the best experience with this one.
                        </p>
                        <div class="notifyBtn" id="notifyBtn">
                            <button>Notify Me</button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-5 p-0">
                <div class="videoBox2">
                    <video autoplay muted loop>
                        <source src="https://www.youtube.com/watch?v=kYXP0rDJiLY&list=RDnDh0PHJbM2Y&index=23" type="video/mp4">
                        Your browser does not support the video tag.
                    </video>
                </div>
            </div>
        </div>
    </div>
</section>


<script>
    document.getElementById('notifyBtn').addEventListener('mousemove', (e) => {
    const btn = document.getElementById('notifyBtn');
    const btnRect = btn.getBoundingClientRect();
    const mouseX = e.clientX;
    const mouseY = e.clientY;
    const btnX = btnRect.left + btnRect.width / 2;
    const btnY = btnRect.top + btnRect.height / 2;
    const deltaX = mouseX - btnX;
    const deltaY = mouseY - btnY;
    const angle = Math.atan2(deltaY, deltaX);
    const distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    const maxDistance = 50; // Adjust as needed

    if (distance <= maxDistance) {
        btn.style.transform = `translate(${deltaX}px, ${deltaY}px)`;
    } else {
        const normalizedX = Math.cos(angle) * maxDistance;
        const normalizedY = Math.sin(angle) * maxDistance;
        btn.style.transform = `translate(${normalizedX}px, ${normalizedY}px)`;
    }
});

// Reset button position when mouse leaves
document.getElementById('notifyBtn').addEventListener('mouseleave', () => {
    const btn = document.getElementById('notifyBtn');
    btn.style.transform = 'translate(-50%, 0)';
});

const text = "Coming Soon"; // Text to animate
const delay = 100; // Delay between each letter in milliseconds

let index = 0;
let forward = true;
const animatedTextElement = document.getElementById("animatedText");

function animateText() {
    if (forward) {
        if (index < text.length) {
            animatedTextElement.textContent += text[index];
            index++;
            setTimeout(animateText, delay);
        } else {
            // Start removing characters in reverse
            forward = false;
            setTimeout(animateText, delay);
        }
    } else {
        if (index > 0) {
            animatedTextElement.textContent = text.substring(0, index - 1);
            index--;
            setTimeout(animateText, delay);
        } else {
            // Animation completed, reset index and start animation again
            index = 0;
            forward = true;
            setTimeout(animateText, delay);
        }
    }
}


animateText(); // Start the animation


</script>


@endsection
