@php
$users = DB::table('users')->where('id','!=', Auth::user()->id)->get();
$friendsData = DB::table('friends')->where('user_id', Auth::user()->id)->whereIn('is_accept', [0, 1])->get();
//<span class="{{ $items->isOnline() ? 'online' : 'offline' }}">.</span>
@endphp
<div class="col-md-3">
    <div class="sidebarLeft side-ri friends-list">
        <div class="search-user">
            <form method="post" id="search-user">
                @csrf
                <div class="form-group">
                    <div class="input-group mb-3">
                        <input type="text" class="form-control" placeholder="Search User" name="search" id="srchUser">
                        <div class="input-group-append">
                            <button class="btn btn-outline-secondary" type="submit"><i class="fa-solid fa-magnifying-glass"></i></button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
        <style>
            .btns button{
                width: 50px;
                height: 25px;
                background: brown;
                border-radius: 20px;
                cursor: pointer;
            }
            .uTab{
                display: flex;
                align-items: center;
                justify-content: space-between;
                padding: 5px;
                background: #ffeaee;
                border-radius: 10px;
            }
        </style>
        <div class="most d-flex justify-content-between">
        </div>
        <div class="user recent_users" id="friends-list">
            @foreach($users as $key => $items)
                @php
                    $friendship = $friendsData->where('friend_id', $items->id)->first();
                @endphp
                <div class="message user-{{ $items->id }} mb-3 uTab">
                    <div class="d-flex align-items-center p-3">
                        <div class="mx-3">
                            @if($items->profile->pic)
                                <img src="{{ asset($items->profile->pic) }}" width="45px" height="45px" class="img-fluid">
                            @else
                                <img src="{{ asset('images/userImage.jpg') }}" width="45px" height="45px" class="img-fluid">
                            @endif
                        </div>
                        <h6>
                            <a href="{{ route('message', ['id' => $items->id]) }}">{{ $items->name }} {{ $items->profile->lname }}</a>
                            <span style="font-size: 10px;">{{ $items->email }}</span>
                        </h6>
                    </div>
                    <div class="d-flex align-items-center justify-content-around btns">
                        <div>
                            @if($friendship)
                                <button class="rmFrnd bg-danger" data-id="{{ $friendship->id }}"><i class="fa fa-x text-white"></i></button>
                            @else
                                <button class="addFrnd bg-primary" data-id="{{ $items->id }}"><i class="fa fa-plus text-white"></i></button>
                            @endif
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>

<!-- Include jQuery first -->
<script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>

<!-- Include toastr CSS and JS files -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>

<script>
    $(document).ready(function(){
        var isRequestInProgress = false;

$('.addFrnd, .rmFrnd').click(function () {
    // Check if a request is already in progress
    if (isRequestInProgress) {
        return;
    }

    // Set the flag to indicate that a request is in progress
    isRequestInProgress = true;

    // Disable the button to prevent multiple clicks
    $(this).prop('disabled', true);

    var friendId = $(this).data('id');
    var csrfToken = $('meta[name="csrf-token"]').attr('content');

    $.ajax({
        url: "{{ route('friendship.post')}}",
        type: "POST",
        data: {
            "_token": csrfToken,
            friendId: friendId,
        },
        headers: {
            'X-CSRF-TOKEN': csrfToken
        },
        success: function (response) {
            console.log(response);
            if (response.success) {
                toastr.success(response.message);
                window.location.reload();
            } else {
                toastr.error(response.message);
            }
        },
        error: function (xhr, status, error) {
            console.log('XHR Status:', status);
            console.log('XHR Error:', error);
            console.log('XHR Response:', xhr.responseText);
            toastr.error('Error processing request. Please check the console for more details.');
        },
        complete: function () {
            // Re-enable the button and reset the flag after the request is complete
            $('.addFrnd, .rmFrnd').prop('disabled', false);
            isRequestInProgress = false;
        }
    });
});

        
        // search friend
        // $('#srchUser').on('input', function () {
        //     var query = $(this).val();
        
        //     $.ajaxSetup({
        //         headers: {
        //             'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        //         }
        //     });
        
        //     $.ajax({
        //         type: "POST",
        //         url: '{{ route('search.friends') }}',
        //         data: {
        //             "_token": "{{ csrf_token() }}",
        //             "query": query,
        //         },
        //         dataType: "json",
        //         success: function (response) {
        //             var friendsList = $('#friends-list');
        
        //             if (response.length > 0) {
        //                 friendsList.empty();
        
        //                 response.forEach(function (userProfile) {
        //                     var userCardHtml = generateUserCard(userProfile.user, userProfile.profile);
        //                     friendsList.append(userCardHtml);
        //                 });
        //             } else {
        //                 friendsList.html('<p>No user found.</p>');
        //             }
        //         },
        //         error: function (xhr, status, error) {
        //             console.error(xhr.responseText);
        //         }
        //     });
        // });
        
        // function generateUserCard(user, profile) {
        //     var cardHtml = `
        //         <div class="message user-${user.id} mb-3 uTab">
        //             <div class="d-flex align-items-center p-3">
        //                 <div class="mx-3">
        //                     ${profile.pic ? `<img src="asset(${profile.pic})" width="45px" height="45px" class="img-fluid">` :
        //                     `<img src="{{ asset('images/userImage.jpg') }}" width="45px" height="45px" class="img-fluid">`}
        //                 </div>
        //                 <h6>
        //                     <a href="{{ route('message', ['id' => '${user.id}']) }">${user.name} ${profile.lname}</a>
        //                     <span style="font-size: 10px;">${user.email}</span>
        //                 </h6>
        //             </div>
        //             <div class="d-flex align-items-center justify-content-around btns">
        //                 <div>
        //                     ${user.friendship ? `<button class="rmFrnd bg-danger" data-id="${user.id}"><i class="fa fa-x text-white"></i></button>` : `<button class="addFrnd bg-primary" data-id="${user.id}"><i class="fa fa-plus text-white"></i></button>`}
        //                 </div>
        //             </div>
        //         </div>
        //     `;
        
        //     return cardHtml;
        // }


    });
</script>
