@extends('layouts.main')
@section('title', 'Account Details')
@section('content')

<?php $segment = Request::segments() ?? 'N/A'; ?>

<style>
        section.banner {
            /* background-image: url(../img/home-banner.jpg); */
            padding-top: 150px !important;
            background-size: cover !important;
            background-repeat: no-repeat;
            background-position: bottom !important;
            padding-bottom: 70px !important;
        }

        .imgBox {
            width: 200px;
            height: 200px;
            background: aquamarine;
            border-radius: 50%;
        }

        .imgBox img {
            width: 200px;
            height: 200px;
            border-radius: 50%;
        }

        .proBg {
            background: linear-gradient(45deg, black, #ff000094);
        }

        .proBg1 {
            padding: 30px;
            background: linear-gradient(45deg, #ff000094, black);
        }

        .tab {
            padding: 10px 20px;
            margin: 5px;
            border: 1px solid #ccc;
            cursor: pointer;
            color: white;
            font-weight: bold;
        }

        .active {
            background-color: white;
            color: black;
            font-weight: bold;
        }

        .tab-content {
            display: none;
            border: 1px solid #ccc;
        }

        .tab-content.active {
            display: block;
        }

        .proBg {
            padding: 50px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .card {
                            position: relative;
                            display: flex;
                            flex-direction: column;
                            min-width: 0;
                            word-wrap: break-word;
                            background-color: #fff;
                            background-clip: border-box;
                            border: 0 solid transparent;
                            border-radius: .25rem;
                            margin-bottom: 1.5rem;
                            box-shadow: 0 2px 6px 0 rgb(218 218 253 / 65%), 0 2px 6px 0 rgb(206 206 238 / 54%);
                        }

                        .me-2 {
                            margin-right: .5rem !important;
                        }
                        
                        .input-group-addon{
                            display: flex;
                            align-items: center;
                            justify-content: center;
                            background: black;
                            padding: 6px 10px;
                        }
    </style>
    @php
        $user = DB::table('profiles')->where('user_id',Auth::id())->first();
        //dump($user);
    @endphp
    <div class="my-account-wrapper position-relative">
        <div class="row mb-5">
            <a href="{{route('account')}}">
                <div style="position: absolute;
                        width: 50px;
                        height: 50px;
                        top: 25px;
                        left: 165px;
                        background: black;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        border-radius: 50%;
                        cursor: pointer;">
                    <i class="fa fa-home" style="color: #F587AC;"></i>
                </div>
            </a>
        </div>
        <div class="container">
            <div class="row proBg">
                <div class="banner-wrapper inner-banner-wrapper">
                    <div class="section-heading text-center">
                        <h1 class="fw-bold" style="font-size: 50px; font-weight: 700; color: white;">Account Details</h1>
                    </div>
                </div>
            </div>
            <div class="row proBg1 justify-content-around">
                <div class="tab active fw-bold" data-tab="1">Profile</div>
                <div class="tab inactive" data-tab="5">Settings</div>
            </div>
            <div class="">
                <div class="tab-content active" id="content1">
                    <div class="d-flex align-items-center">
                        <div class="container">
                            <div class="main-body">
                                <form action="{{ route('update.account') }}" method="post" enctype="multipart/form-data" id="accountForm">
                                    @csrf
                                    <div class="row mt-4">
                                        <div class="col-lg-4">
                                            <div class="card">
                                                <div class="card-body">
                                                    <div class="d-flex flex-column align-items-center text-center">
                                                        <img src="{{asset(Auth::user()->profile->pic)}}" alt="Admin"
                                                            class="rounded-circle p-1 bg-danger" style="width: 200px; height: 200px;">
                                                        <div class="mt-3">
                                                            <h4 class="fw-bold ">{{ Auth::user()->name }}</h4>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-8">
                                            <div class="card">
                                                <div class="card-body">
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Full Name</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="hidden" name="profile" class="form-control" value="{{asset(Auth::user()->profile->pic)}}">
                                                            <input type="text" name="name" class="form-control" value="{{ Auth::user()->name ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Email</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="email" class="form-control" value="{{ Auth::user()->email ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Last Name</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="lname" class="form-control" value="{{ $user->lname ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Bio</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="bio" class="form-control" value="{{ $user->bio ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Localisation</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="localisation" class="form-control" value="{{ $user->localisation ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Date of Birth</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="dob" class="form-control" value="{{ $user->dob ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Gender</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="gender" class="form-control" value="{{ $user->gender ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Country</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="country" class="form-control" value="{{ $user->country ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">State</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="state" class="form-control" value="{{ $user->state ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">City</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="city" class="form-control" value="{{ $user->city ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Address</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="address" class="form-control" value="{{ $user->address ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Postal Code</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="postal" class="form-control" value="{{ $user->postal ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Qualification</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="qualification" class="form-control" value="{{ $user->qualification ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Facebook</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="facebook" class="form-control" value="{{ $user->facebook ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Twitter</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="twitter" class="form-control" value="{{ $user->twitter ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Instagram</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="instagram" class="form-control" value="{{ $user->instagram ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row text-center">
                                                        <div class="col-sm-12 text-secondary">
                                                            <input type="submit" class="btn btn-danger px-4" value="Update">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-content bg-white" id="content5" style="padding: 25px; overflow-y: auto; position: relative;">
                    <div class="container">
                            <div class="row justify-content-center">
                                <div class="col-7 mx-auto text-dark">
                                    <div class="card p-5">
                                        <h2 class="text-center text-dark mt-4 mb-4" style="font-weight: bold;">Change Password</h2>
                                        <hr>
                                        <form action="{{ route('update.account') }}" method="post" enctype="multipart/form-data">
                                            @csrf
                                            <div class="form-group">
                                                <label for="password">Password</label>
                                                <div class="input-group" id="show_hide_password">
                                                    <input class="form-control" name="password" type="password" required>
                                                    <div class="input-group-addon">
                                                        <a href="#" class="toggle-password" data-target="password">
                                                            <i class="fa fa-eye-slash" aria-hidden="true"></i>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="password_confirmation">Confirm Password</label>
                                                <div class="input-group" id="show_hide_confirm_password">
                                                    <input class="form-control" name="password_confirmation" type="password" required>
                                                    <div class="input-group-addon">
                                                        <a href="#" class="toggle-password" data-target="confirm_password">
                                                            <i class="fa fa-eye-slash" aria-hidden="true"></i>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row justify-content-center">
                                                <button class="btn btn-danger">Update Password</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                </div>
            </div>
        </div>
    </div>


<!--add sq video-->
<div class="modal fade" id="addSqVideo" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title text-dark fw-bold" id="exampleModalLabel">Video Detail</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form method="POST" action="" accept-charset="UTF-8" enctype="multipart/form-data">
                                @csrf
                                <div class="form-body text-dark">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                               <label for="product_title">Video Title</label>
                                               <input class="form-control" required="required" name="video_title" type="text" id="product_title">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="price">Tags</label>
                                                <input class="form-control" required="required" name="video_tags" type="text" id="price">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="description">Description</label>
                                                <textarea type="text" name="video_description" class="form-control ckeditor"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="image">Video Thumbnail</label>
                                                <input class="form-control dropify" name="video_thumbnail" type="file" id="image">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="image">Video File</label>
                                                <input class="form-control dropify" name="video_file" type="file" id="image">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    </div>
                                    <div class="form-actions text-right pb-0">
                                        <input class="btn btn-success" type="submit" value="Create">
                                    </div>
                                </div>
                            </form>
      </div>
    </div>
  </div>
</div>

<!--add short video-->
<div class="modal fade" id="addShrtVideo" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title text-dark fw-bold" id="exampleModalLabel">Short Video</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form method="POST" action="" accept-charset="UTF-8" enctype="multipart/form-data">
                                @csrf
                                <div class="form-body text-dark">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                               <label for="product_title">Video Title</label>
                                               <input class="form-control" required="required" name="video_title" type="text" id="product_title">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="price">Tags</label>
                                                <input class="form-control" required="required" name="video_tags" type="text" id="price">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="description">Description</label>
                                                <textarea class="form-control ckeditor" name="video_description" cols="50" rows="10"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="image">Video Thumbnail</label>
                                                <input class="form-control dropify" name="video_thumbnail" type="file" id="image">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="image">Video File</label>
                                                <input class="form-control dropify" name="video_file" type="file" id="image">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    </div>
                                    <div class="form-actions text-right pb-0">
                                        <input class="btn btn-success" type="submit" value="Create">
                                    </div>
                                </div>
                            </form>
      </div>
    </div>
  </div>
</div>


<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
            <script>
                $(document).ready(function () {
                    $('.tab-content:not(.active)').hide();
                    // Handle tab clicks
                    $('.tab').click(function () {
                        // Get the data-tab attribute value
                        var tabNumber = $(this).data('tab');
                        // Hide all tab contents
                        $('.tab-content').hide().find('*').hide();
                        // Show the selected tab content
                        $('#content' + tabNumber).show().find('*').show();
                        // Remove 'active' class from all tabs
                        $('.tab').removeClass('active');
                        // Add 'active' class to the selected tab
                        $(this).addClass('active');
                    });
                    
                    $("#show_hide_password a").on('click', function(event) {
                        event.preventDefault();
                        if($('#show_hide_password input').attr("type") == "text"){
                            $('#show_hide_password input').attr('type', 'password');
                            $('#show_hide_password i').addClass( "fa-eye-slash" );
                            $('#show_hide_password i').removeClass( "fa-eye" );
                        }else if($('#show_hide_password input').attr("type") == "password"){
                            $('#show_hide_password input').attr('type', 'text');
                            $('#show_hide_password i').removeClass( "fa-eye-slash" );
                            $('#show_hide_password i').addClass( "fa-eye" );
                        }
                    });
                    
                    $("#show_hide_confirm_password a").on('click', function(event) {
                        event.preventDefault();
                        if($('#show_hide_confirm_password input').attr("type") == "text"){
                            $('#show_hide_confirm_password input').attr('type', 'password');
                            $('#show_hide_confirm_password i').addClass( "fa-eye-slash" );
                            $('#show_hide_confirm_password i').removeClass( "fa-eye" );
                        }else if($('#show_hide_confirm_password input').attr("type") == "password"){
                            $('#show_hide_confirm_password input').attr('type', 'text');
                            $('#show_hide_confirm_password i').removeClass( "fa-eye-slash" );
                            $('#show_hide_confirm_password i').addClass( "fa-eye" );
                        }
                    });

                });
            </script>

<script src="//cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            $('.ckeditor').ckeditor();
        });
    </script>
    
    <script src="https://meet.jit.si/external_api.js"></script>
    <script>
        const domain = 'meet.jit.si';
        const options = {
            roomName: 'Live-Streaming',
            width: '100%',
            height: '100%',
            parentNode: document.querySelector('#streamVideo'),
            configOverwrite: {
                startWithAudioMuted: true,
                startWithVideoMuted: true,
            },
            interfaceConfigOverwrite: {
                SHOW_CHROME_EXTENSION_BANNER: false,
            },
        };

        const api = new JitsiMeetExternalAPI(domain, options);

        api.addEventListener('videoConferenceJoined', () => {
            console.log('Video conference joined');
        });

        api.addEventListener('videoConferenceLeft', () => {
            console.log('Video conference left');
        });
    </script>
    
@endsection
    