@extends('layouts.main')

@section('css')
    <link rel="stylesheet" href="{{ asset('css/trip-taken.css') }}">
    <link rel="stylesheet" href="{{ asset('css/chatbox.css') }}">
    <!--<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/fancybox@3.5.7/dist/jquery.fancybox.min.css">-->

    <style>
        .nav.flex-column {
            background-color: transparent;
            border-radius: 0;
            width: 100%;
            padding: 0;
        }

        .date {
            text-decoration: none !important;
        }

        .trip-right p strong {
            text-decoration: none !important;
        }

        .Bottom-footer {
            position: relative;
            padding-top: 1rem;
            padding-bottom: 1rem;
            background: #ff7eae;
        }

        .trip-taken-head {

            color: #f587ac;
            font-size: 120px;
            font-weight: 500;
            font-family: Mishella;
            text-align: center;

        }
    </style>
@endsection

@section('content')
<script src="https://code.jquery.com/jquery-3.7.0.min.js"
        integrity="sha256-2Pmvv0kuTBOenSvLm6bvfBSSHrUJ+3A7x6P5Ebd07/g=" crossorigin="anonymous"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.0.1/css/toastr.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.0.1/js/toastr.js"></script>

    <script>
        $(document).ready(function() {
            toastr.options.timeOut = 10000;

            @if (Session::has('success'))
                toastr.success('{{ Session::get('success') }}');
            @endif

            @if (Session::has('info'))
                toastr.info('{{ Session::get('info') }}');
            @endif

            @if (Session::has('warning'))
                toastr.warning('{{ Session::get('warning') }}');
            @endif

            @if (Session::has('error'))
                toastr.error('{{ Session::get('error') }}');
            @endif
        });
    </script>
    <section class="home-sec1">
        <div class="container-fluid">
            <div class="row">
                <!--Recent Post-->
                @include('account.post')
                <div class="col-md-6">
                    <!--trip taken-->
                    <div class="tab-content center-bar" id="myTabContent">
                        <div class="row">
                            <div class="col-md-12">
                                <style>
                                    .cardTrip .col-md-3:hover {
                                        transform: scale(1.1);
                                    }
                                </style>
                                <div class="row mb-5 cardTrip"
                                    style="padding: 20px; background: white; border-radius: 25px; box-shadow: 5px 5px 5px #d3d2d2;">
                                    <a href="{{ route('account') }}">
                                        <div
                                            style="    position: absolute;
                                        top: -5px;
                                        left: -20px;
                                        width: 50px;
                                        height: 50px;
                                        background: black;
                                        display: flex;
                                        align-items: center;
                                        justify-content: center;
                                        border-radius: 50%;
                                        cursor: pointer;">
                                            <i class="fa fa-home" style="color: #F587AC;"></i>
                                        </div>
                                    </a>
                                    <div class="col-md-3">
                                        <a href="{{ route('account') }}">
                                            <img class="img img-fluid" src="https://i.ibb.co/RckM0Pn/d1.png">
                                        </a>
                                    </div>
                                    <div class="col-md-3">
                                        <a
                                            href="https://stagingweblink.com/custom-backend/dream-vacation/public/trips-taken">
                                            <img class="img img-fluid"
                                                src="https://stagingweblink.com/custom-backend/dream-vacation/public/images/d1.png">
                                        </a>
                                    </div>
                                    <div class="col-md-3">
                                        <a
                                            href="https://stagingweblink.com/custom-backend/dream-vacation/public/share-trips">
                                            <img class="img img-fluid"
                                                src="https://stagingweblink.com/custom-backend/dream-vacation/public/images/d2.png">
                                        </a>
                                    </div>
                                    <div class="col-md-3">
                                        <a
                                            href="https://stagingweblink.com/custom-backend/dream-vacation/public/future-trips">
                                            <img class="img img-fluid"
                                                src="https://stagingweblink.com/custom-backend/dream-vacation/public/images/d3.png">
                                        </a>
                                        <!--<a data-toggle="tab" id="new-trip-form-tab" href="#new-trip-form" role="tab" aria-controls="new-trip-form" aria-selected="false">-->
                                        <!--    <img class="img img-fluid" src="https://stagingweblink.com/custom-backend/dream-vacation/public/images/d4.png">-->
                                        <!--</a>-->
                                    </div>

                                </div>
                            </div>

                            <div class="col-md-12">
                                <h2 class="trip-taken-head ">Copied Trip</h2>
                            </div>
                            <div class="tab-pane" id="new-trip-form" role="tabpanel" aria-labelledby="new-trip-form-tab">
                                <form action="{{ route('new.trip.post') }}" enctype="multipart/form-data" method="post" class="save-trip-form-post" id="new-trip-form-post">
                                    @csrf
                                    <input type="hidden" name="isFeatured" value="" class="isFeatured-value" />
                                    <input type="hidden" name="ctrId" value="{{ $copiedTrip->id }}" class="" />
                                    <div class="form-group">
                                        <input type="file" class="form-control new-dropify" name="new-images[]"
                                            id="new-image" multiple>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <div class="parent-star">
                                                    <label class="">Location</label>
                                                    <div class="rating">
                                                        <label>
                                                            <input type="radio" name="loca-stars" value="1" />
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="loca-stars" value="2" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="loca-stars" value="3" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="loca-stars" value="4" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="loca-stars" value="5" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                    </div>
                                                </div>
                                                <input type="text" class="form-control" name="new-location"
                                                    id="new-location" placeholder="Enter Your Location Here" value="{{ $originalTrip->location }}" required>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="font-weight-light">Rating</label>

                                            </div>
                                        </div>
                                    </div>
                                    <hr />
                                    <div class="row">

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>Date</label>
                                                <input type="text" class="form-control" placeholder="Start Date"
                                                    onfocus="(this.type='date')" name="new-start-date"
                                                    id="new-start-date" value="{{ $originalTrip->start_date }}" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label></label>
                                                <input type="text" class="form-control" placeholder="End Date"
                                                    onfocus="(this.type='date')" name="new-end-date" value="{{ $originalTrip->end_date }}" id="new-end-date"
                                                    required>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <label>Comments</label>
                                            <textarea class="form-control" name="date-comment" id="new-airline" value="{{ $originalTrip->date_comment }}"
                                                placeholder="Weather? Crowds? Would you go back at the same time of year again?" required></textarea>
                                        </div>
                                    </div>
                                    <hr />
                                    <div class="row">

                                        <div class="col-md-12">
                                            <div class="form-group">

                                                <div class="parent-star">
                                                    <label>Airline</label>
                                                    <div class="rating1">
                                                        <label>
                                                            <input type="radio" name="air-stars" value="1" />
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="air-stars" value="2" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="air-stars" value="3" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="air-stars" value="4" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="air-stars" value="5" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                    </div>
                                                </div>
                                                <textarea class="form-control" name="new-airline" id="new-airline" value="{{ $originalTrip->airline }}" placeholder="Comment Related To Airline..."></textarea>

                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group" style="
    display: flex;
    
    padding: 10px;
">
                                                <div style="
    background: #c7bebe;
    padding: 7px;
    padding-right: 15px;
    padding-left: 15px;
">$</div>
                                                <input type="text" class="form-control" name="airline-cost" value="{{ $originalTrip->airline_cost }}"
                                                    placeholder="Airline Cost" />

                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label></label>
                                                <input type="number" class="form-control" name="flight-quantity" value="{{ $originalTrip->flight_quantity }}"
                                                    placeholder="Quantity of flights" />
                                            </div>
                                        </div>
                                        <div class="col-md-4">

                                            <input type="text" placeholder="Date tickets were booked"
                                                onfocus="(this.type='date')" class="form-control" name="ticket-booked" value="{{ $originalTrip->ticket_date }}"
                                                placeholder="" />

                                        </div>

                                    </div>
                                    <hr />
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group ">
                                                <div class="parent-star">
                                                    <label>Accommodations</label>
                                                    <div class="rating2">
                                                        <label>
                                                            <input type="radio" name="acco-stars" value="1" />
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="acco-stars" value="2" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="acco-stars" value="3" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="acco-stars" value="4" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="acco-stars" value="5" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                    </div>
                                                </div>

                                                <textarea class="form-control" name="new-accommodation" value="{{ $originalTrip->accommodation }}" id="new-accommodation"
                                                    placeholder="hotel, rental, other...">{{ $originalTrip->accommodation }}</textarea>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label></label>
                                                <input type="text" class="form-control" name="accoma_link" value="{{ $originalTrip->accommodation_link }}"
                                                    placeholder="Link to accommodations" />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label></label>
                                                <input type="text" class="form-control" name="accoma_another_link" value="{{ $originalTrip->accommodation_link }}"
                                                    placeholder="Link to other accommodations that you considered, but did not pick" />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                                                                      <div class="form-group" style="
    display: flex;
    
    padding: 10px;
">
                                                <div style="
    background: #c7bebe;
    padding: 7px;
    padding-right: 15px;
    padding-left: 15px;
">$</div>
                                                <input type="text" class="form-control" name="accoma_cost" value="{{ $originalTrip->accommodation_link }}"
                                                    placeholder="Cost" />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                                                                    <div class="form-group" style="
    display: flex;
    
    padding: 10px;
">

                                                <input type="text" class="form-control" name="accoma_thoughts_cost" value="{{ $originalTrip->acco_other_link }}"
                                                    placeholder="Thoughts on the cost" />
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <textarea class="form-control" name="accommodation_comment" value="{{ $originalTrip->accommodation_comment }}" id="accommodation_comment" placeholder="Comment....">{{ $originalTrip->accommodation_comment }}</textarea>
                                            </div>
                                        </div>

                                    </div>
                                    <hr />
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <div class="parent-star">

                                                    <label>Restaurants </label>
                                                    <div class="rating3">
                                                        <label>
                                                            <input type="radio" name="rest-stars" value="1" />
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="rest-stars" value="2" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="rest-stars" value="3" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="rest-stars" value="4" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="rest-stars" value="5" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                    </div>
                                                </div>
                                                <textarea class="form-control" name="new-restaurants" value="{{ $originalTrip->restaurants }}" id="new-restaurants" placeholder="dine in, take away...">{{ $originalTrip->restaurants }}</textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label></label>
                                                <textarea class="form-control" name="friendly-restaurants" value="{{ $originalTrip->kids_family_friendly }}" id="new-restaurants" placeholder="Kid/Family friendly">{{ $originalTrip->kids_family_friendly }}</textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label></label>
                                                <textarea class="form-control" name="other-restaurants" value="{{ $originalTrip->other_restraunts_option }}" id="new-restaurants"
                                                    placeholder="Other restaurants that were options, but did not try">{{ $originalTrip->other_restraunts_option }}</textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label></label>
                                                <textarea class="form-control" name="best-thing-restaurants" value="{{ $originalTrip->restraunt_best_thing }}" id="new-restaurants"
                                                    placeholder="Best things you ate and drank">{{ $originalTrip->restraunt_best_thing }}</textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <textarea class="form-control" name="comments-restaurants" value="{{ $originalTrip->restranut_comment }}" id="new-restaurants" placeholder="Comment...">{{ $originalTrip->restranut_comment }}</textarea>
                                            </div>
                                        </div>

                                    </div>
                                    <hr />
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <div class="parent-star">
                                                    <label>Rental Car </label>
                                                    <div class="rating4">
                                                        <label>
                                                            <input type="radio" name="rent-stars" value="1" />
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="rent-stars" value="2" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="rent-stars" value="3" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="rent-stars" value="4" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                        <label>
                                                            <input type="radio" name="rent-stars" value="5" />
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                            <span class="icon">★</span>
                                                        </label>
                                                    </div>
                                                </div>
                                                <input class="form-control" name="new-rental-car" value="{{ $originalTrip->rental_car }}" id="new-rental-car"
                                                    placeholder="Company" />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                                                                     <div class="form-group" style="
    display: flex;
    padding: 10px;
">
                                                <div style="
    background: #c7bebe;
    padding: 7px;
    padding-right: 15px;
    padding-left: 15px;
">$</div>
                                                <input type="text" class="form-control" name="rental-cost" value="{{ $originalTrip->car_cost }}"
                                                    id="rental-cost" placeholder="Cost" />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label></label>
                                                <input type="text" class="form-control" name="rental-avaibility" value="{{ $originalTrip->car_availability }}"
                                                    id="new-rental-car" placeholder="Availability" />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label></label>
                                                <input type="text" class="form-control" name="rental-quality" value="{{ $originalTrip->car_quality }}"
                                                    id="new-rental-car" placeholder="Quality of Car" />
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label></label>
                                                <input type="date" placeholder="Check-in" onfocus="(this.type='date')" value="{{ $originalTrip->car_checkin }}"
                                                    class="form-control" name="rental-check-date" id="new-rental-car" />
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <textarea class="form-control" name="rental-comment" value="{{ $originalTrip->rental_comment }}" id="new-rental-car" placeholder="Comment">{{ $originalTrip->rental_comment }}</textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <hr />
                                    <div class="row">
                                        <div class="col-md-12">
                                            <label>Excursions</label>
                                            <div class="form-group">
                                                <label></label>
                                                <textarea class="form-control" name="new-excursions-car" id="new-excursions-car" value="{{ $originalTrip->excursions_car }}"
                                                    placeholder="Excursions/Things to do">{{ $originalTrip->excursions_car }}</textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label></label>
                                                <textarea class="form-control" name="new-comments" value="{{ $originalTrip->comments }}" id="new-comments" placeholder="Overall Comments">{{ $originalTrip->comments }}</textarea>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <button class="btn btn-pink btn-exist" type="submit">Save As Taken Trip</button>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <button class="btn btn-pink btn-future" type="submit">Save As Future Trip</button>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="loader">
                                                <!--<img src="{{ asset('images/loader.gif') }}">-->
                                            </div>
                                            <div class="success-msg"></div>
                                            <div class="error-msg"></div>
                                        </div>
                                    </div>
                                </form>
                            </div>

                        </div>
                    </div>
                    <!--trip taken-->
                </div>
                @include('account.chatbox')
                <!--Online Friends-->
                @include('account.friends')
            </div>
        </div>
    </section>



    <!-- contact foam end  -->

    <!--@include('layouts/front.footer')-->
@endsection
@section('js')
<script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script>
        $(document).ready(function() {
        
            function handleFormSubmission(formId, isFeaturedValue) {
                var form = $(formId);
                form.find('.loader').show();
                
                var formData = new FormData(form[0]);
        
                $.ajax({
                    url: form.attr('action'),
                    method: "POST",
                    data: formData,
                    dataType: 'JSON',
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function(data) {
                        form.find('.loader').hide();
                        if (data.status) {
                            form.find('.success-msg').addClass('alert alert-success');
                            form.find('.success-msg').html(data.message);
                        } else {
                            form.find('.error-msg').addClass('alert alert-danger');
                            form.find('.error-msg').html('Please Contact Administrator');
                        }
        
                        form[0].reset();
                        form.find('.dropify-clear').click();
                    }
                });
            }
        
            $('.btn-exist').click(function() {
                $('.isFeatured-value').val(2);
                // handleFormSubmission('#save-trip-form-post');
            });
        
            $('.btn-future').click(function() {
                $('.isFeatured-value').val(1);
                // handleFormSubmission('#save-trip-form-post');
            });
        
            // $('#new-trip-form-post').on('submit', function(event) {
            //     event.preventDefault();
            //     handleFormSubmission('#new-trip-form-post');
            // });
        
            // $('#save-trip-form-post').on('submit', function(event) {
            //     event.preventDefault();
            //     handleFormSubmission('#save-trip-form-post');
            // });
        
        });
        
    </script>

@endsection
