@extends('layouts.main')
@section('css')
    <style>
        .icon button {
            outline: none;
            background: transparent;
            border: none;
        }

        .nav-item a {
            color: #8e8e95 !important;
            font-weight: 400;
        }

    .chat_bar {
        display: flex;
    align-items: center;
    background: cadetblue;
    border-radius: 33px 33px 0px 0px;
    }

    .user_chatImg {
        width: 60px;
        height: 60px;
        border-radius: 50%;
    }

    .chat_user {
        margin-left: 15px;
    }

    .chat_user h6 {
        margin: 0;
        color: #fff;
    }

    .chat_user p {
        margin: 5px 0 0;
        color: #fff;
    }

    .chattingTwo {
        overflow-y: scroll;
        height: 450px;
        margin-top: 0px;
            background: currentColor;
    padding: 13px;
    }

    .chat {
        list-style: none;
        margin: 0;
        padding: 0;
    }

    .chat li {
        padding-bottom: 5px;
        margin-top: 10px;
    }

    .chatOne img {
        width: 75px;
        border-radius: 50%;
        margin-right: 10px;
    }

    .chatOne p {
        margin: 0;
    }

    .check_status span {
        display: flex;
        align-items: center;
        color: #fff;
    }

    .check_status img {
        margin-right: 5px;
    }

    .userchatTwo p {
        margin: 0;
    }

    .userchatTwo img {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        margin-right: 10px;
    }

    .check_status_two span {
        display: flex;
        align-items: center;
        color: #fff;
    }

    .check_status_two img {
        margin-right: 5px;
    }

    .in {
            margin-top: 0px;
    background: cadetblue;
    border-radius: 0px 0px 20px 20px;
    }

    .writ {
        display: flex;
        align-items: center;
    }

    .writ img {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        margin-right: 10px;
    }

    .comment {
        width: calc(100% - 50px);
        padding: 10px;
        border: none;
        border-radius: 25px;
        background-color: #4c0000;
        color: #fff;
    }

    .icon ul {
        list-style: none;
        padding: 0;
        margin: 0;
        display: flex;
    }

    .icon li {
        margin-right: 10px;
    }

    .icon button {
        background: none;
        border: none;
        cursor: pointer;
    }
</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css"
integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
@endsection
@section('content')
    <section class="home-sec1">
        <div class="container-fluid">
            <div class="row">
                <!--Recent Post-->
                @include('account.post')
                <div class="col-lg-6">
                    <!-- Chat Section -->
                    <div class="chatSection" style="margin-top: 85px;">
                        <div class="chat_bar">
                            <div style="margin: 10px 0px 0px 10px;">
                                @if ($user->profile->pic != '')
                                    <img src="{{ asset($user->profile->pic) }}" class="user_chatImg" alt="">
                                @else
                                    <img src="{{ asset('images/userImage.jpg') }}" class="user_chatImg" alt="">
                                @endif
                            </div>
                            <div class="chat_user">
                                <h6>{{ $user->name }}</h6>
                                <p>
                                    @if ($user->isOnline())
                                        <span>online</span>
                                    @else
                                        <span>offline</span>
                                    @endif

                                </p>
                            </div>
                        </div>
                        <div class="chattingTwo">
                            @foreach ($messages as $key => $value)
                                @if ($value->sender_id == $user->id && $value->reciever_id == Auth::user()->id)
                                    @php
                                        $userImg = App\User::where('id', $user->id)->first();
                                        $createdDate = Carbon\Carbon::parse($value->created_at);
                                        $timeWithAMPM = $createdDate->format('h:i A');
                                    @endphp
                                    <div class="chat">
                                        <div class="chatOne">
                                            <img src="{{ $userImg->profile->pic != null ? asset($userImg->profile->pic) : asset('images/userImage.jpg') }}"
                                                width="75px" alt="">
                                            <p>{{ $value->message }}</p>
                                        </div>
                                        <div class="check_status">
                                            <span> <img src="{{ asset('images/check.png') }}" class="img-fluid"
                                                    alt="">
                                                {{ $timeWithAMPM }}</span>
                                        </div>
                                    </div>
                                @elseif($value->sender_id == Auth::user()->id && $value->reciever_id == $user->id)
                                    @php

                                        $userImg = App\User::where('id', Auth::user()->id)->first();

                                        $createdDate = Carbon\Carbon::parse($value->created_at);

                                        $timeWithAMPM = $createdDate->format('h:i A');
                                    @endphp
                                    <div class="userchatTwo">
                                        <p class="" style="margin: 0px 5px;">{{ $value->message }}</p>
                                        <div>
                                            <img src="{{ $userImg->profile->pic != null ? asset($userImg->profile->pic) : asset('images/userImage.jpg') }}"
                                                class="img-fluid" alt="">
                                        </div>
                                    </div>
                                    <div class="check_status_two position-relative">
                                        <span class="short_mesg text-dark"> <img src="{{ asset('images/check.png') }}" alt=""></span>
                                        <div style="font-size: 8px; position: absolute; right: -30px;">{{ $timeWithAMPM }}</div>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                        <div class="in">
                            <form id="send-message" enctype="multipart/form-data">
                                @csrf
                                <input type="hidden" name="reciever_id" class="reciever_id" value="{{ $user->id }}" />
                                <input type="hidden" name="sender_id" class="sender_id" value="{{ Auth::user()->id }}" />
                                <div class="dis">
                                    <div class="writ">
                                        @if (Auth::user()->profile->pic)
                                            <img src="{{ asset(Auth::user()->profile->pic) }}" width="40px"
                                                height="40px" class="img-fluid">
                                        @else
                                            <img src="{{ asset('images/userImage.jpg') }}" width="40px" height="40px"
                                                class="img-fluid">
                                        @endif
                                        <input type="text" name="comment" class="comment text-dark"
                                            placeholder="Write your message">
                                    </div>
                                    <div class="icon">
                                        <ul>
                                            <li> <button type="button" id="submitMessage"><i
                                                        class="fa-solid fa-paper-plane jsahd"></i></button></li>
                                        </ul>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                </div>

                <!--Online Friend-->
                @include('account.friends')
            </div>
        </div>
    </section>
@endsection
@section('js')
    <script>
        $('#submitMessage').click(function() {
            var reciverId = $(this).closest('.chatSection').find('.reciever_id').val();
            var comment = $(this).closest('.chatSection').find('.comment').val();
            var csrfToken = $('meta[name="csrf-token"]').attr('content');
            var e = this;
            console.log(comment);
            $.ajax({
                url: "{{ route('messagePost') }}",
                type: "POST",
                data: {
                    "_token": "{{ csrf_token() }}",
                    reciverId: reciverId,
                    comment: comment,
                },
                headers: {
                    'X-CSRF-TOKEN': "{{ csrf_token() }}",
                },
                success: function(response) {
                    if (response.status) {
                        console.log(response);
                        var img = response.user['pic'];
                        if (img === null) {
                            img = 'images/userImage.jpg';
                        }
                        const currentTime = new Date();
                        const hours = currentTime.getHours();
                        const minutes = currentTime.getMinutes();
                        const ampm = hours >= 12 ? 'PM' : 'AM';

                        // Convert to 12-hour format
                        const hours12 = hours % 12 || 12;

                        const formattedTime = `${hours12}:${minutes < 10 ? '0' : ''}${minutes} ${ampm}`;
                        console.log(formattedTime);
                        const publicPath = '{{ route('home') }}';
                        var userImg = `${publicPath}/${img}`;
                        $(e).parent().parent().parent().parent().parent().find('.comment').val('');
                        $('.chattingTwo').append('<div class="userchatTwo"><p>' + response.message +
                            '</p> <img src="' + userImg +
                            '" class="img-fluid" alt=""> </div><div class="check_status_two"><span class="short_mesg"> <img src="images/check.png"  alt="">' +
                            formattedTime + '</span></div>')
                    } else {
                        console.log(response.message);
                    }

                },
                error: function(err) {
                    if (err.status == 422) { 

                        toastr.error(err.responseJSON.message);

                    }
                }
            });
        });
    </script>
@endsection