@extends('layouts.main')
@section('title', 'Account Details')
@section('content')

<?php $segment = Request::segments() ?? 'N/A'; ?>

<style>
        section.banner {
            /* background-image: url(../img/home-banner.jpg); */
            padding-top: 150px !important;
            background-size: cover !important;
            background-repeat: no-repeat;
            background-position: bottom !important;
            padding-bottom: 70px !important;
        }

        .imgBox {
            width: 200px;
            height: 200px;
            background: aquamarine;
            border-radius: 50%;
        }

        .imgBox img {
            width: 200px;
            height: 200px;
            border-radius: 50%;
        }

        .proBg {
            background: linear-gradient(45deg, black, #ff44f194);
        }

        .proBg1 {
            padding: 30px;
            background: linear-gradient(45deg, #ff44f194, black);
        }

        .tab {
            padding: 10px 20px;
            margin: 5px;
            border: 1px solid #ccc;
            cursor: pointer;
            color: white;
            font-weight: bold;
        }

        .active {
            background-color: white;
            color: black;
            font-weight: bold;
        }

        .tab-content {
            display: none;
            border: 1px solid #ccc;
        }

        .tab-content.active {
            display: block;
        }

        .proBg {
            padding: 50px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .card {
                            position: relative;
                            display: flex;
                            flex-direction: column;
                            min-width: 0;
                            word-wrap: break-word;
                            background-color: #fff;
                            background-clip: border-box;
                                border-radius: 25px;
    box-shadow: 0 0 40px 0px rgba(0, 0, 0, 0.17);
                            margin-bottom: 1.5rem;
                        }

                        .me-2 {
                            margin-right: .5rem !important;
                        }
                        
                        .input-group-addon{
                            display: flex;
                            align-items: center;
                            justify-content: center;
                            background: black;
                            padding: 6px 10px;
                        }
    </style>
    @php
        $user = DB::table('profiles')->where('user_id',Auth::id())->first();
        $chats = DB::table('message')->where('sender_id',Auth::id())->orWhere('reciever_id',Auth::id())->get();
        $friendsData = DB::table('friends')->where('user_id', Auth::user()->id)->whereIn('is_accept', [0, 1])->get();
        $trips = DB::table('new_trip')->where('user_id', Auth::user()->id)->where('isFeatured', 1)->get();
        //dump($user,$friendsData);
    @endphp
    <div class="my-account-wrapper position-relative">
        <div class="row mb-5">
            <a href="{{route('account')}}">
                <div style="position: absolute;
                        width: 50px;
                        height: 50px;
                        top: 25px;
                        left: 165px;
                        background: black;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        border-radius: 50%;
                        cursor: pointer;">
                    <i class="fa fa-home" style="color: #F587AC;"></i>
                </div>
            </a>
        </div>
        <div class="container">
            <div class="row proBg">
                <div class="banner-wrapper inner-banner-wrapper">
                    <div class="section-heading text-center">
                        <h1 class="fw-bold" style="font-size: 50px; font-weight: 700; color: white;">Account Details</h1>
                    </div>
                </div>
            </div>
            <div class="row proBg1 justify-content-around">
                <div class="tab active fw-bold" data-tab="1">Profile</div>
                <div class="tab inactive" data-tab="5">Settings</div>
            </div>
            <div class="">
                <div class="tab-content active" id="content1">
                    <div class="d-flex align-items-center">
                        <div class="container">
                            <div class="main-body">
                                <form action="{{ route('update.account') }}" method="post" enctype="multipart/form-data" id="accountForm">
                                    @csrf
                                    <div class="row mt-4">
                                        <div class="col-lg-6 mx-auto">
                                            <div class="layout">
                                                <div class="profile">
                                                    <div class="profile__picture">
                                                        @if(Auth::user()->profile->pic)
                                                        <img src="{{asset(Auth::user()->profile->pic)}}" alt="ananddavis" />
                                                        @else
                                                        <img src="http://i.pravatar.cc/250?img=58" alt="ananddavis" />
                                                        @endif
                                                    </div>
                                                    <div class="profile__header">
                                                        <div class="profile__account">
                                                            <h4 class="profile__username">{{ Auth::user()->name }}</h4>
                                                        </div>
                                                    </div>
                                                    <br><hr>
                                                    <div class="profile__stats">
                                                        <div class="profile__stat">
                                                            <div class="profile__icon profile__icon--gold"><i class="fas fa-wallet"></i></div>
                                                            <div class="profile__value">{{ $chats->count() }}
                                                                <div class="profile__key">Chats</div>
                                                            </div>
                                                        </div>
                                                        <div class="profile__stat">
                                                            <div class="profile__icon profile__icon--blue"><i class="fas fa-users"></i></div>
                                                            <div class="profile__value">{{ $friendsData->count() }}
                                                                <div class="profile__key">Friends</div>
                                                            </div>
                                                        </div>
                                                        <div class="profile__stat">
                                                            <div class="profile__icon profile__icon--pink"><i class="fas fa-plane"></i></div>
                                                            <div class="profile__value">{{ $trips->count() }}
                                                                <div class="profile__key">Trips</div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-8 mx-auto">
                                            <div class="card">
                                                <div class="card-body">
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Profile</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="file" name="profile" class="form-control" value="{{asset(Auth::user()->profile->pic)}}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Full Name</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="hidden" name="profile" class="form-control" value="{{asset(Auth::user()->profile->pic)}}">
                                                            <input type="text" name="name" class="form-control" value="{{ Auth::user()->name ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Email</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="email" class="form-control" value="{{ Auth::user()->email ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Last Name</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="lname" class="form-control" value="{{ $user->lname ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Bio</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="bio" class="form-control" value="{{ $user->bio ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <!--<div class="row mb-3">-->
                                                    <!--    <div class="col-sm-6">-->
                                                    <!--        <h6 class="mb-0">Localisation</h6>-->
                                                    <!--    </div>-->
                                                    <!--    <div class="col-sm-6 text-secondary">-->
                                                    <!--        <input type="text" name="localisation" class="form-control" value="{{ $user->localisation ?? 'N/A' }}">-->
                                                    <!--    </div>-->
                                                    <!--</div>-->
                                                    <!--<div class="row mb-3">-->
                                                    <!--    <div class="col-sm-6">-->
                                                    <!--        <h6 class="mb-0">Date of Birth</h6>-->
                                                    <!--    </div>-->
                                                    <!--    <div class="col-sm-6 text-secondary">-->
                                                    <!--        <input type="text" name="dob" class="form-control" value="{{ $user->dob ?? 'N/A' }}">-->
                                                    <!--    </div>-->
                                                    <!--</div>-->
                                                    <!--<div class="row mb-3">-->
                                                    <!--    <div class="col-sm-6">-->
                                                    <!--        <h6 class="mb-0">Gender</h6>-->
                                                    <!--    </div>-->
                                                    <!--    <div class="col-sm-6 text-secondary">-->
                                                    <!--        <input type="text" name="gender" class="form-control" value="{{ $user->gender ?? 'N/A' }}">-->
                                                    <!--    </div>-->
                                                    <!--</div>-->
                                                    <!--<div class="row mb-3">-->
                                                    <!--    <div class="col-sm-6">-->
                                                    <!--        <h6 class="mb-0">Country</h6>-->
                                                    <!--    </div>-->
                                                    <!--    <div class="col-sm-6 text-secondary">-->
                                                    <!--        <input type="text" name="country" class="form-control" value="{{ $user->country ?? 'N/A' }}">-->
                                                    <!--    </div>-->
                                                    <!--</div>-->
                                                    <!--<div class="row mb-3">-->
                                                    <!--    <div class="col-sm-6">-->
                                                    <!--        <h6 class="mb-0">State</h6>-->
                                                    <!--    </div>-->
                                                    <!--    <div class="col-sm-6 text-secondary">-->
                                                    <!--        <input type="text" name="state" class="form-control" value="{{ $user->state ?? 'N/A' }}">-->
                                                    <!--    </div>-->
                                                    <!--</div>-->
                                                    <!--<div class="row mb-3">-->
                                                    <!--    <div class="col-sm-6">-->
                                                    <!--        <h6 class="mb-0">City</h6>-->
                                                    <!--    </div>-->
                                                    <!--    <div class="col-sm-6 text-secondary">-->
                                                    <!--        <input type="text" name="city" class="form-control" value="{{ $user->city ?? 'N/A' }}">-->
                                                    <!--    </div>-->
                                                    <!--</div>-->
                                                    <!--<div class="row mb-3">-->
                                                    <!--    <div class="col-sm-6">-->
                                                    <!--        <h6 class="mb-0">Address</h6>-->
                                                    <!--    </div>-->
                                                    <!--    <div class="col-sm-6 text-secondary">-->
                                                    <!--        <input type="text" name="address" class="form-control" value="{{ $user->address ?? 'N/A' }}">-->
                                                    <!--    </div>-->
                                                    <!--</div>-->
                                                    <!--<div class="row mb-3">-->
                                                    <!--    <div class="col-sm-6">-->
                                                    <!--        <h6 class="mb-0">Postal Code</h6>-->
                                                    <!--    </div>-->
                                                    <!--    <div class="col-sm-6 text-secondary">-->
                                                    <!--        <input type="text" name="postal" class="form-control" value="{{ $user->postal ?? 'N/A' }}">-->
                                                    <!--    </div>-->
                                                    <!--</div>-->
                                                    <!--<div class="row mb-3">-->
                                                    <!--    <div class="col-sm-6">-->
                                                    <!--        <h6 class="mb-0">Qualification</h6>-->
                                                    <!--    </div>-->
                                                    <!--    <div class="col-sm-6 text-secondary">-->
                                                    <!--        <input type="text" name="qualification" class="form-control" value="{{ $user->qualification ?? 'N/A' }}">-->
                                                    <!--    </div>-->
                                                    <!--</div>-->
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Facebook</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="facebook" class="form-control" value="{{ $user->facebook ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Twitter</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="twitter" class="form-control" value="{{ $user->twitter ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <div class="row mb-3">
                                                        <div class="col-sm-6">
                                                            <h6 class="mb-0">Instagram</h6>
                                                        </div>
                                                        <div class="col-sm-6 text-secondary">
                                                            <input type="text" name="instagram" class="form-control" value="{{ $user->instagram ?? 'N/A' }}">
                                                        </div>
                                                    </div>
                                                    <hr>
                                                    <div class="row text-center">
                                                        <div class="col-sm-12 text-secondary">
                                                            <input type="submit" class="btn btn-danger px-4" value="Update">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-content bg-white" id="content5" style="padding: 25px; overflow-y: auto; position: relative;">
                    <div class="container">
                            <div class="row justify-content-center">
                                <div class="col-7 mx-auto text-dark">
                                    <div class="card p-5">
                                        <h2 class="text-center text-dark mt-4 mb-4" style="font-weight: bold;">Change Password</h2>
                                        <hr>
                                        <form action="{{ route('update.account') }}" method="post" enctype="multipart/form-data">
                                            @csrf
                                            <div class="form-group">
                                                <label for="password">Password</label>
                                                <div class="input-group" id="show_hide_password">
                                                    <input class="form-control" name="password" type="password" required>
                                                    <div class="input-group-addon">
                                                        <a href="#" class="toggle-password" data-target="password">
                                                            <i class="fa fa-eye-slash" aria-hidden="true"></i>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="password_confirmation">Confirm Password</label>
                                                <div class="input-group" id="show_hide_confirm_password">
                                                    <input class="form-control" name="password_confirmation" type="password" required>
                                                    <div class="input-group-addon">
                                                        <a href="#" class="toggle-password" data-target="confirm_password">
                                                            <i class="fa fa-eye-slash" aria-hidden="true"></i>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="row justify-content-center">
                                                <button class="btn btn-danger">Update Password</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                </div>
            </div>
        </div>
    </div>

<style>
    .layout {
            align-items: center;
            display: flex;
            justify-content: center;
        }

        @keyframes popUp {
            from {
                transform: scale(0);
                opacity: 0;
            }

            to {
                transform: scale(1);
                opacity: 1;
            }
        }

        @keyframes slideUp {
            from {
                transform: translateY(5px);
                opacity: 0;
            }

            to {
                transform: translateY(0px);
                opacity: 1;
            }
        }

        .profile {
            animation: popUp ease-in-out 350ms;
            background: #ffffff;
            border-radius: 25px;
            box-shadow: 0 0 40px 0px rgba(0, 0, 0, 0.17);
            margin-top: 40px;
            padding: 28px 30px 30px 35px;
            position: relative;
            width: 100%;
        }

        .profile__account {
            align-self: center;
            display: flex;
            flex: 1;
            justify-content: flex-end;
            padding-left: 135px;
        }

        .profile__button {
            border-radius: 50px;
            border: 1px solid #000000;
            color: #000000;
            display: block;
            font-family: "Montserrat", sans-serif;
            font-size: 13px;
            padding: 10px;
            text-align: center;
            text-decoration: none;
            transition: ease-in-out 250ms background, ease-in-out 250ms color;
        }

        .profile__button:hover {
            background: #000000;
            color: #ffffff;
        }

        .profile__edit {
            flex: none;
            margin-left: 30px;
            width: 140px;
        }

        .profile__header {
            display: flex;
            margin-bottom: 20px;
        }

        .profile__icon {
            flex: none;
            font-size: 1.5em;
            margin-right: 10px;
            padding-top: 3px;
        }

        .profile__icon--gold {
            color: #eab100;
        }

        .profile__icon--blue {
            color: #8faae8;
        }

        .profile__icon--pink {
            color: #ff86af;
        }

        .profile__key {
            font-family: "Montserrat", sans-serif;
            font-size: 13px;
            font-weight: 400;
            text-align: center;
        }

        .profile__picture {
            background: #ffffff;
            border-radius: 100px;
            border: 10px solid #ffffff;
            height: 125px;
            position: absolute;
            top: -40px;
            width: 125px;
        }

        .profile__picture:before {
            border-radius: 100px;
            box-shadow: 0 0 40px 0px rgba(0, 0, 0, 0.17);
            content: "";
            height: calc(100% + 20px);
            left: -10px;
            position: absolute;
            top: -10px;
            width: calc(100% + 20px);
            z-index: -1;
        }

        .profile__picture img {
            border-radius: 100px;
            height: 100%;
            width: 100%;
        }

        .profile__stat {
            animation: slideUp ease-in-out 350ms forwards;
            border-right: 1px solid #e9e9e9;
            display: flex;
            flex: 1;
            justify-content: center;
            opacity: 0;
            padding: 10px 4px;
            transform: translateY(5px);
        }

        .profile__stat:last-of-type {
            border-right: none;
        }

        .profile__stat:nth-child(1) {
            animation-delay: 400ms;
        }

        .profile__stat:nth-child(2) {
            animation-delay: 500ms;
        }

        .profile__stat:nth-child(3) {
            animation-delay: 600ms;
        }

        .profile__stats {
            display: flex;
        }

        .profile__username {
            font-family: "Montserrat", sans-serif;
            font-weight: 600;
            margin: 0;
            text-align: right;
        }

        .profile__value {
            font-family: "Montserrat", sans-serif;
            font-size: 28px;
            font-weight: 700;
            text-align: center;
        }
</style>
<!--add sq video-->
<div class="modal fade" id="addSqVideo" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title text-dark fw-bold" id="exampleModalLabel">Video Detail</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form method="POST" action="" accept-charset="UTF-8" enctype="multipart/form-data">
                                @csrf
                                <div class="form-body text-dark">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                               <label for="product_title">Video Title</label>
                                               <input class="form-control" required="required" name="video_title" type="text" id="product_title">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="price">Tags</label>
                                                <input class="form-control" required="required" name="video_tags" type="text" id="price">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="description">Description</label>
                                                <textarea type="text" name="video_description" class="form-control ckeditor"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="image">Video Thumbnail</label>
                                                <input class="form-control dropify" name="video_thumbnail" type="file" id="image">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="image">Video File</label>
                                                <input class="form-control dropify" name="video_file" type="file" id="image">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <hr>
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    </div>
                                    <div class="form-actions text-right pb-0">
                                        <input class="btn btn-success" type="submit" value="Create">
                                    </div>
                                </div>
                            </form>
      </div>
    </div>
  </div>
</div>

<!--add short video-->
<div class="modal fade" id="addShrtVideo" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title text-dark fw-bold" id="exampleModalLabel">Short Video</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form method="POST" action="" accept-charset="UTF-8" enctype="multipart/form-data">
                                @csrf
                                <div class="form-body text-dark">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                               <label for="product_title">Video Title</label>
                                               <input class="form-control" required="required" name="video_title" type="text" id="product_title">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="price">Tags</label>
                                                <input class="form-control" required="required" name="video_tags" type="text" id="price">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="description">Description</label>
                                                <textarea class="form-control ckeditor" name="video_description" cols="50" rows="10"></textarea>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="image">Video Thumbnail</label>
                                                <input class="form-control dropify" name="video_thumbnail" type="file" id="image">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="image">Video File</label>
                                                <input class="form-control dropify" name="video_file" type="file" id="image">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                    </div>
                                    <div class="form-actions text-right pb-0">
                                        <input class="btn btn-success" type="submit" value="Create">
                                    </div>
                                </div>
                            </form>
      </div>
    </div>
  </div>
</div>


<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
            <script>
                $(document).ready(function () {
                    $('.tab-content:not(.active)').hide();
                    // Handle tab clicks
                    $('.tab').click(function () {
                        // Get the data-tab attribute value
                        var tabNumber = $(this).data('tab');
                        // Hide all tab contents
                        $('.tab-content').hide().find('*').hide();
                        // Show the selected tab content
                        $('#content' + tabNumber).show().find('*').show();
                        // Remove 'active' class from all tabs
                        $('.tab').removeClass('active');
                        // Add 'active' class to the selected tab
                        $(this).addClass('active');
                    });
                    
                    $("#show_hide_password a").on('click', function(event) {
                        event.preventDefault();
                        if($('#show_hide_password input').attr("type") == "text"){
                            $('#show_hide_password input').attr('type', 'password');
                            $('#show_hide_password i').addClass( "fa-eye-slash" );
                            $('#show_hide_password i').removeClass( "fa-eye" );
                        }else if($('#show_hide_password input').attr("type") == "password"){
                            $('#show_hide_password input').attr('type', 'text');
                            $('#show_hide_password i').removeClass( "fa-eye-slash" );
                            $('#show_hide_password i').addClass( "fa-eye" );
                        }
                    });
                    
                    $("#show_hide_confirm_password a").on('click', function(event) {
                        event.preventDefault();
                        if($('#show_hide_confirm_password input').attr("type") == "text"){
                            $('#show_hide_confirm_password input').attr('type', 'password');
                            $('#show_hide_confirm_password i').addClass( "fa-eye-slash" );
                            $('#show_hide_confirm_password i').removeClass( "fa-eye" );
                        }else if($('#show_hide_confirm_password input').attr("type") == "password"){
                            $('#show_hide_confirm_password input').attr('type', 'text');
                            $('#show_hide_confirm_password i').removeClass( "fa-eye-slash" );
                            $('#show_hide_confirm_password i').addClass( "fa-eye" );
                        }
                    });

                });
            </script>

<script src="//cdn.ckeditor.com/4.14.0/standard/ckeditor.js"></script>

    <script type="text/javascript">
        $(document).ready(function() {
            $('.ckeditor').ckeditor();
        });
    </script>
    
    <script src="https://meet.jit.si/external_api.js"></script>
    <script>
        const domain = 'meet.jit.si';
        const options = {
            roomName: 'Live-Streaming',
            width: '100%',
            height: '100%',
            parentNode: document.querySelector('#streamVideo'),
            configOverwrite: {
                startWithAudioMuted: true,
                startWithVideoMuted: true,
            },
            interfaceConfigOverwrite: {
                SHOW_CHROME_EXTENSION_BANNER: false,
            },
        };

        const api = new JitsiMeetExternalAPI(domain, options);

        api.addEventListener('videoConferenceJoined', () => {
            console.log('Video conference joined');
        });

        api.addEventListener('videoConferenceLeft', () => {
            console.log('Video conference left');
        });
    </script>
    
@endsection
    