@extends('layouts.main')

@section('css')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.min.css" integrity="sha512-EZSUkJWTjzDlspOoPSpUFR0o0Xy7jdzW//6qhUkoZ9c4StFkVsp9fbbd0O06p9ELS3H486m4wmrCELjza4JEog==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<!--<link rel="stylesheet" href="{{ asset('css/dropify.min.css') }}">-->
<link rel="stylesheet" href="{{asset('css/trip-form.css')}}">
<style>
.Bottom-footer{
    position: relative;
    padding-top: 1rem;
    padding-bottom: 1rem;
    background: #ff7eae;    
}
.formSec{
    padding: 30px;
    background: #f78fcc99;
    color: white;
    font-weight: 700;
}
.editForm{
    margin-top: 30px;
}
</style>

<link rel="stylesheet" href="{{asset('css/chatbox.css')}}">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/fancybox@3.5.7/dist/jquery.fancybox.min.css">
  
@endsection
@section('content')


<section class="home-sec1">
    <div class="container-fluid">
        <div class="row">
            <!--Recent Post-->
            @include('account.post')
            <div class="col-md-6">
                <div class="trips-info" style="margin-top: 100px;">
                        <div class="row">
                            <div class="col">
                                <ul class="nav nav-tabs" id="myTab" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link " id="my-trips-tab"  href="{{route('tripTaken')}}" role="tab" >My Trips Taken</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="shared-trips-tab" href="{{route('shareTrip')}}" role="tab">Shared Trips</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="future-trips-tab"  href="{{route('futureTrip')}}" role="tab" >Future Trips</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="new-trip-form-tab" data-toggle="tab" href="#new-trip-form" role="tab" aria-controls="new-trip-form" aria-selected="false">New Trip Form</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                <div class="editForm">
                    <h4 class="fw-bold">Edit Post</h4>
                    <hr>
                    @php
                        //dd($post,$images);
                    @endphp
                    <div class="formSec">
                        <form action="{{ route('feed.update') }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" id="" class="form-control" value="{{ $post->user_id }}" name="user_id" required>
                            <input type="hidden" id="" class="form-control" value="{{ $post->id }}" name="post_id" required>
                            <div class="form-group mb-3">
                                <label for="file">Choose a file:</label>
                                <input type="file" id="file" class="form-control" value="{{ $images->image }}" name="post_file" accept=".jpg, .jpeg, .png">
                            </div>
                            <div style="width: 250px; height: 220px;">
                                <img src="{{ asset($images->image) }}" alt="" style="width: 100%; height: 200px;">
                            </div>
                            <div class="form-group mb-3">
                                <label for="email">Post Content:</label>
                                <textarea type="text" id="email" class="form-control" rows="10" cols="20" name="content">{{ $post->content }}</textarea>
                            </div>
                            <div class="text-center">
                                <button type="submit" class="btn btn-success w-50 text-white fw-bold">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            @include('account.chatbox')

            <!--Online Friends-->
            @include('account.friends')
        </div>
    </div>
</section>



@endsection

@section('js')

<script src="https://code.jquery.com/jquery-3.7.1.min.js" integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>


<script src="https://cdn.jsdelivr.net/npm/@fancyapps/fancybox@3.5.7/dist/jquery.fancybox.min.js"></script>
<!-- JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js" 
integrity="sha512-8QFTrG0oeOiyWo/VM9Y8kgxdlCryqhIxVeRpWSezdRRAvarxVtwLnGroJgnVW9/XBRduxO/z1GblzPrMQoeuew==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<!--<script src="{{ asset('js/dropify.min.js') }}"></script>-->



@endsection