@extends('layouts.main')

@section('css')


<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.min.css" integrity="sha512-EZSUkJWTjzDlspOoPSpUFR0o0Xy7jdzW//6qhUkoZ9c4StFkVsp9fbbd0O06p9ELS3H486m4wmrCELjza4JEog==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link rel="stylesheet" href="{{asset('css/trip-taken.css')}}">
<link rel="stylesheet" href="{{asset('css/chatbox.css')}}">
<!--<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/fancybox@3.5.7/dist/jquery.fancybox.min.css">-->
<link rel="stylesheet" href="{{asset('css/trip-form.css')}}">

<style>
.img-div{
      position: relative;
      width: 50%;
      background: #333;
}    
.image-area img{
  max-width: 100%;
  height: auto;
}
.remove-image {
    display: none;
    position: absolute;
    top: -12px;
    right: 2px;
    border-radius: 10em;
    padding: 2px 6px 3px;
    text-decoration: none;
    font: 700 11px/12px sans-serif;
    background: #555;
    border: 3px solid #fff;
    color: #FFF;
    box-shadow: 0 2px 6px rgba(0,0,0,0.5), inset 0 2px 4px rgba(0,0,0,0.3);
    text-shadow: 0 1px 2px rgba(0,0,0,0.5);
    -webkit-transition: background 0.5s;
    transition: background 0.5s;
}
.remove-image:hover {
    background: #E54E4E;
    padding: 3px 7px 5px;
    top: -15px;
    right: 1px;
}
.remove-image:active {
 background: #E54E4E;
  top: -10px;
right: -1px;
}
</style>

@endsection

@section('content')

<section class="home-sec1">
    <div class="container-fluid">
        <div class="row">
            <!--Recent Post-->
            @include('account.post')
            <div class="col-md-6">
                    <!--trip taken-->
                <div class="tab-content center-bar" id="myTabContent">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="tab-content" id="v-pills-tabContent">
                                @php
                                    $image = DB::table('new_trip_image')->where('trip_id',$tripDetail->id)->get();
                                @endphp
                                <div class="myTab">
                                    
                                
                                    <form class="save-trip-form-post" enctype="multipart/form-data" id="" method="post" action="{{ route('edit.trip.post') }}">
                                        @csrf
                                        <input type="hidden" name="trip_id" value="{{$tripDetail->id}}" />
                                        <input type="hidden" name="isFeatured" value="{{$tripDetail->isFeatured}}" class="isFeatured-value"/>
                                        <div class="form-group">
                                            <input type="file" class="form-control new-dropify" name="new-images[]" id="new-image" multiple>
                                        </div>
                                        
                                        @php
                                            $images = DB::table('new_trip_image')->where('trip_id',$tripDetail->id)->get();
                                        @endphp
                                        
                                        <div class="row">
                                            @foreach($images as $key => $item)
                                                <div class="col-md-2">
                                                    <div class="image-area">
                                                        <img src="{{asset($item->trip_image)}}"/>
                                                        <a class="remove-image" href="javascript:void(0);" data-id="{{$item->id}}" style="display: inline;">&#215;</a>
                                                    </div>
                                                </div>        
                                            @endforeach
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <div class="parent-star">
                                                       
                                                       <label class="">Location</label>
                                                        <div class="rating">
                                                            <label>
                                                                <input type="radio" name="loca-stars" value="1" <?php if($tripDetail->loca_stars === 1)echo'checked';?>/>
                                                                <span class="icon">★</span>
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="loca-stars" value="2" <?php if($tripDetail->loca_stars === 2)echo'checked';?>/>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="loca-stars" value="3" <?php if($tripDetail->loca_stars === 3)echo'checked';?>/>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>   
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="loca-stars" value="4" <?php if($tripDetail->loca_stars === 4)echo'checked';?>/>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="loca-stars" value="5" <?php if($tripDetail->loca_stars === 5)echo'checked';?>/>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                            </label>
                                                        </div> 
                                                    </div>
                                                    
                                                    <input type="text" class="form-control" name="new-location" id="new-location" placeholder="Enter Your Location Here" value="{{$tripDetail->location}}" required>
                                                </div>
                                            </div>
                                            <!--<div class="col-md-12">-->
                                            <!--    <div class="form-group">-->
                                                    <!--<label class="font-weight-light">Rating</label>-->
                                                    
                                            <!--    </div>-->
                                            <!--</div>-->
                                        </div>
                                        <hr/>
                                        <div class="row">
                                            
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>Date</label>
                                                    <input type="date" class="form-control"  name="new-start-date" id="new-start-date" value="{{Carbon\Carbon::parse($tripDetail->start_date)->format('Y-m-d')}}" required>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label></label>
                                                    <input type="date" class="form-control"  name="new-end-date" id="new-end-date" value="{{Carbon\Carbon::parse($tripDetail->end_date)->format('Y-m-d')}}" required>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <!--<label>Comments</label>-->
                                                <textarea class="form-control" name="date-comment" id="new-airline" placeholder="Weather? Crowds? Would you go back at the same time of year again?"  required>{{$tripDetail->date_comment}}</textarea>
                                            </div>
                                        </div>
                                        <hr/>
                                        <div class="row">
                                            
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                        
                                                    <div class="parent-star">
                                                        <label>Airline</label>
                                                        <div class="rating1">
                                                            <label>
                                                                <input type="radio" name="air-stars" value="1"  <?php if($tripDetail->airline_rating === '1')echo'checked';?> />
                                                                <span class="icon">★</span>
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="air-stars" value="2" <?php if($tripDetail->airline_rating === '2')echo'checked';?>/>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="air-stars" value="3" <?php if($tripDetail->airline_rating === '3')echo'checked';?>/>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>   
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="air-stars" value="4"<?php if($tripDetail->airline_rating === '4')echo'checked';?>/>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="air-stars" value="5" <?php if($tripDetail->airline_rating === '5')echo'checked';?>/>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                            </label>
                                                        </div> 
                                                    </div>
                                                    
                                                    <textarea class="form-control" name="new-airline" id="new-airline" placeholder="Comment Related To Airline...">{{$tripDetail->airline}}</textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <!--<label></label>-->
                                                    <input type="text"  class="form-control" name="airline-cost" placeholder="Airline Cost" value="{{$tripDetail->airline_cost}}" />
                                                    
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <!--<label></label>-->
                                                    <input type="number"  class="form-control" name="flight-quantity" placeholder="Quantity of flights" value="{{$tripDetail->flight_quantity}}" />
                                                    
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <input type="date"   class="form-control" name="ticket-booked" value="{{ $tripDetail->ticket_date != null ? Carbon\Carbon::parse($tripDetail->ticket_date)->format('Y-m-d') : '' }}" placeholder="" />
                                                
                                            </div>
                                        </div>
                                        <hr/>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group ">
                                                    <div class="parent-star">
                                                        <label>Accommodations</label>
                                                        <div class="rating2">
                                                            <label>
                                                                <input type="radio" name="acco-stars" value="1" <?php if($tripDetail->accoma_rating === '1')echo'checked';?>/>
                                                                <span class="icon">★</span>
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="acco-stars" value="2"  <?php if($tripDetail->accoma_rating === '2')echo'checked';?>/>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="acco-stars" value="3"  <?php if($tripDetail->accoma_rating === '3')echo'checked';?>/>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>   
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="acco-stars" value="4" <?php if($tripDetail->accoma_rating === '4')echo'checked';?> />
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="acco-stars" value="5"  <?php if($tripDetail->accoma_rating === '5')echo'checked';?>/>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                            </label>
                                                        </div> 
                                                    </div>
                                                    
                                                    <textarea class="form-control" name="new-accommodation" id="new-accommodation" placeholder="hotel, rental, other..." required>{{$tripDetail->accommodation}}</textarea>
                                                </div>
                                            </div>
                                            
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <!--<label></label>-->
                                                    <input type="text" class="form-control" name="accoma_link" placeholder="Link to accommodations" value="{{$tripDetail->accommodation_link}}" />
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <!--<label></label>-->
                                                    <input type="text" class="form-control" name="accoma_another_link" placeholder="Link to other accommodations that you considered, but did not pick" value="{{$tripDetail->acco_other_link}}" />
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <!--<label></label>-->
                                                    <input type="text" class="form-control" name="accoma_cost" placeholder="Cost" value="{{$tripDetail->accommodation_cost}}"/>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <!--<label></label>-->
                                                    <input type="text" class="form-control" name="accoma_thoughts_cost" placeholder="Thoughts on the cost" value="{{$tripDetail->acco_thoughts_cost}}" />
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <textarea class="form-control" name="accommodation_comment" id="accommodation_comment" placeholder="Comment....">{{$tripDetail->accommodation_comment}}</textarea>
                                                </div>
                                            </div>
                                            
                                        </div>
                                        <hr/>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <div class="parent-star">
                                                        
                                                    <label>Restaurants </label>
                                                    <div class="rating3">
                                                            <label>
                                                                <input type="radio" name="rest-stars" value="1" <?php if($tripDetail->restaurants_rating === '1')echo'checked';?> />
                                                                <span class="icon">★</span>
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="rest-stars" value="2" <?php if($tripDetail->restaurants_rating === '2')echo'checked';?> />
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="rest-stars" value="3" <?php if($tripDetail->restaurants_rating === '3')echo'checked';?>/>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>   
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="rest-stars" value="4" <?php if($tripDetail->restaurants_rating === '4')echo'checked';?>/>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="rest-stars" value="5" <?php if($tripDetail->restaurants_rating === '5')echo'checked';?> />
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                            </label>
                                                        </div> 
                                                    </div>
                                                    <textarea class="form-control" name="new-restaurants" id="new-restaurants" placeholder="dine in, take away...">{{$tripDetail->restaurants}}</textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label></label>
                                                    <textarea class="form-control" name="friendly-restaurants" id="new-restaurants" placeholder="Kid/Family friendly">{{$tripDetail->kids_family_friendly}}</textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <!--<label></label>-->
                                                    <textarea class="form-control" name="other-restaurants" id="new-restaurants" placeholder="Other restaurants that were options, but did not try">{{$tripDetail->other_restraunts_option}}</textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <!--<label></label>-->
                                                    <textarea class="form-control" name="best-thing-restaurants" id="new-restaurants" placeholder="Best things you ate and drank">{{$tripDetail->restraunt_best_thing}}</textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <textarea class="form-control" name="comments-restaurants" id="new-restaurants" placeholder="Comment...">{{$tripDetail->restranut_comment}}</textarea>
                                                </div>
                                            </div>
                                            
                                        </div>
                                        <hr/>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <div class="parent-star">
                                                       
                                                    <label>Rental Car </label>
                                                    
                                                    <div class="rating4">
                                                            <label>
                                                                <input type="radio" name="rent-stars" <?php if($tripDetail->rental_rating === '1')echo'checked';?> />
                                                                <span class="icon">★</span>
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="rent-stars" <?php if($tripDetail->rental_rating === '2')echo'checked';?>/>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="rent-stars"  <?php if($tripDetail->rental_rating === '3')echo'checked';?>/>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>   
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="rent-stars" <?php if($tripDetail->rental_rating === '4')echo'checked';?> />
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                            </label>
                                                            <label>
                                                                <input type="radio" name="rent-stars" <?php if($tripDetail->rental_rating === '5')echo'checked';?> />
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                                <span class="icon">★</span>
                                                            </label>
                                                        </div> 
                                                    </div>
                                                    <input class="form-control" name="new-rental-car" id="new-rental-car" placeholder="Company" value="{{$tripDetail->rental_car}}"/>
                                                </div>    
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <!--<label></label>-->
                                                    <input type="text" class="form-control" name="rental-cost" id="rental-cost" placeholder="Cost" value="{{$tripDetail->car_cost}}"/>
                                                </div>    
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <!--<label></label>-->
                                                    <input type="text" class="form-control" name="rental-avaibility" id="new-rental-car" placeholder="Availability" value="{{$tripDetail->car_availability}}"/>
                                                </div>    
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <!--<label></label>-->
                                                    <input type="text" class="form-control" name="rental-quality" id="new-rental-car" placeholder="Quality of Car" value="{{$tripDetail->car_quality}}"/>
                                                </div>    
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <!--<label></label>-->
                                                    <input type="date" class="form-control" name="rental-check-date" id="new-rental-car" value="{{ $tripDetail->ticket_date != null ? Carbon\Carbon::parse($tripDetail->car_checkin)->format('Y-m-d') : '' }}"/>
                                                </div>    
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <textarea class="form-control" name="rental-comment" id="new-rental-car" placeholder="Comment">{{$tripDetail->rental_comment}}</textarea>
                                                </div>    
                                            </div>
                                        </div>
                                        <hr/>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label>Excursions</label>
                                                    <textarea class="form-control" name="new-excursions-car" id="new-excursions-car" placeholder="Excursions/Things to do">{{$tripDetail->excursions_car}}</textarea>
                                                </div>
                                            </div> 
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <!--<label></label>-->
                                                    <textarea class="form-control" name="new-comments" id="new-comments" placeholder="Overall Comments">{{$tripDetail->comments}}</textarea>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <button class="btn btn-pink" type="submit">Update As Taken Trip</button>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <button class="btn btn-pink" type="submit">Update As Future Trip</button>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                    <div class="loader">
                                                        <img src="{{ asset('images/loader.gif') }}">
                                                    </div>
                                                    <div class="success-msg"></div>
                                                    <div class="error-msg"></div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <!--trip taken-->
            </div>
            @include('account.chatbox')
            <!--Online Friends-->
            @include('account.friends')
        </div>
    </div>
</section>



@endsection
@section('js')

<script src="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/js/dropify.min.js" integrity="sha512-8QFTrG0oeOiyWo/VM9Y8kgxdlCryqhIxVeRpWSezdRRAvarxVtwLnGroJgnVW9/XBRduxO/z1GblzPrMQoeuew==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script type="text/javascript" src=" https://platform-api.sharethis.com/js/sharethis.js#property=60ad47e8bfb0df0011352a02&product=inline-share-buttons " async="async"></script>
<script>
    $(document).ready(function () {
        $('.dropify').dropify();
    });
    $('.new-dropify').dropify();
</script>
<script>
    $('.btn-exist').click(function(){
        $('.isFeatured-value').val(2);
        $('.save-trip-form-post').submit();    
    });
    $('.btn-future').click(function(){
               $('.isFeatured-value').val(1);
               $('.save-trip-form-post').submit();
    });
    $('#save-trip-form-post').on('submit', function(event){
                $(this).find('.loader').show();
                var elem = $(this);
                event.preventDefault();
                var formData = new FormData(this);
                $.ajax({
                    url:"{{ route('edit.trip.post') }}",
                    method:"POST",
                    data:new FormData(this),
                    dataType:'JSON',
                    contentType: false,
                    cache: false,
                    processData: false,
                    success:function(data){
                        $(elem).find('.loader').hide();
                        if(data.status){
                            $(elem).find('.success-msg').addClass('alert alert-success');
                            $(elem).find('.success-msg').html(data.message);
                            url = '{{route("account")}}';
                            console.log(url);
                            window.location.href = url;
                        }else{
                            $(elem).find('.error-msg').addClass('alert alert-danger');
                            $(elem).find('.error-msg').html('Please Contact to Administrator');
                        }
                        $('#new-trip-form-post')[0].reset()
                        $(elem).find('.dropify-clear').click();
                    }
                })
                console.log(formData);
    });
</script>

<script>
    $('.remove-image').click(function(){
       var imageId = $(this).data('id'); 
       var ele = $(this)
       
        $.ajax({
                url:"{{ route('delete.trip.image') }}",
                method:"POST",
                data:{
                    "_token": "{{ csrf_token() }}",
                    imageId:imageId
                },
               
                success:function(data){
               
                    if(data.status){
                        toastr.success(data.message);
                        ele.parent().parent().remove()
                    }else{
                       toastr.error(data.message);
                    }
                
                }
        })
                
    });
</script>
@endsection

