<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <!-- font awsome  -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.3.0/css/all.min.css"
        integrity="sha512-SzlrxWUlpfuzQ+pcUCosxcglQRNAq/DZjVsC0lE40xsADsfeQoEypE+enwcOiGjk/bSuGGKHEyjSoQ1zVisanQ=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <!-- google fonts  -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap"
        rel="stylesheet">
    <!-- moving letters  -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
    <!-- data aos  -->
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <!-- custom css  -->
    <link rel="stylesheet" href="css/custom.css">
    <link rel="stylesheet" href="css/responsive.css">

    <title>Trucker Trip!</title>
</head>

<body>
    <div class="loadermain">
        <div class="loader-container">
            <div class="loaderMain">
                <img src="images/loader.gif" alt="">
            </div>
        </div>
    </div>

    <header>
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <nav class="navbar navbar-expand-lg navbar-light">
                        <a class="navbar-brand" href="index.php">
                            <img src="images/logo.png" class="img-fluid" alt="">
                        </a>
                        <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                            data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                            aria-expanded="false" aria-label="Toggle navigation">
                            <span class="navbar-toggler-icon"></span>
                        </button>
                        <div class="collapse navbar-collapse" id="navbarSupportedContent">
                            <ul class="navbar-nav">
                                <li class="nav-item active">
                                    <a class="nav-link" href="#">Home <span class="sr-only">(current)</span></a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" href="#">Contact Us</a>
                                </li>
                            </ul>
                            <div class="button-container">
                                <a href="#" class="btn custom-btn pink">Log in</a>
                                <a href="#" class="btn custom-btn blue">Sign up</a>
                            </div>
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </header>

    <section class="section-1">
        <div class="container">
            <div class="row">
                <div class="col-lg-7">
                    <div class="site-Title">
                        <span class="title ml2">
                            Welcome To
                        </span>
                        <!-- <h1 class="heading-1">
                            Tucker Trips
                        </h1> -->
                        <h1 class="ml6 heading-1">
                            <span class="text-wrapper">
                                <span class="letters"> Tucker Trips</span>
                            </span>
                        </h1>
                        <p class="para">
                            At Tucker Trips, we understand the importance of honest and reliable travel information.
                            That's why we pride ourselves on providing you with truthful reviews, reliable logistics,
                            and dependable information to make your travel experiences exceptional.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="section-2 py">
        <div class="container">
            <div class="row">
                <div class="col-lg-6">
                    <div class="trucker-trip-slogans" data-aos="fade-right">
                        <div class="icons">
                            <figure>
                                <img src="images/location.png" class="img-fluid" alt="">
                            </figure>
                        </div>
                        <div class="slogans">
                            <h2 class="heading-2">
                                Unlock the Key to Unforgettable Adventures
                            </h2>
                            <p>
                                Explore our platform and gain access to candid reports that reflect real experiences.
                                From accommodations to attractions, restaurants to activities, we provide you with
                                reputable recaps that help you make informed decisions.
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="trucker-trip-slogans" data-aos="fade-left">
                        <div class="icons">
                            <figure>
                                <img src="images/map.png" class="img-fluid" alt="">
                            </figure>
                        </div>
                        <div class="slogans">
                            <h2 class="heading-2">
                                Plan Your Next Trip with Confidence
                            </h2>
                            <p>
                                Trust our community's firsthand experiences and recommendations. Our members provide
                                truthful reviews and reliable logistics, giving you the information you need to plan
                                your itinerary, find the best places to stay, and discover hidden gems.
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="trucker-trip-slogans" data-aos="fade-right" data-aos-duration="3000">
                        <div class="icons">
                            <figure>
                                <img src="images/copules.png" class="img-fluid" alt="">
                            </figure>
                        </div>
                        <div class="slogans">
                            <h2 class="heading-2">
                                Unlock the Key to Unforgettable Adventures
                            </h2>
                            <p>
                                Join a community of travelers who share your passion for exploration. Connect with
                                friends and family who have similar travel interests and benefit from their candid
                                reports and reputable recaps. Together, we create a network of trustworthy۔۔
                            </p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="trucker-trip-slogans" data-aos="fade-left" data-aos-duration="3000">
                        <div class="icons">
                            <figure>
                                <img src="images/journey.png" class="img-fluid" alt="">
                            </figure>
                        </div>
                        <div class="slogans">
                            <h2 class="heading-2">
                                Start Your Journey with Tucker Trips
                            </h2>
                            <p>
                                Sign up today and experience the power of truthful reviews, reliable logistics, and
                                dependable information. Let us be your guide as you embark on unforgettable travel
                                experiences. Together, we'll explore the world with the support and insights of our
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="section-3">
        <div class="container">
            <div class="row align-items-center justify-content-between">
                <div class="col-lg-5">
                    <div class="trucker-clients" data-aos="flip-left" data-aos-duration="3000">
                        <figure>
                            <img src="images/trucker-clients.png" class="img-fluid" alt="">
                        </figure>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="community-content" data-aos="fade-left" data-aos-duration="3000">
                        <h3 class="heading-3">
                            Discover A Community Of
                            <span class="d-block">
                                Like-Minded Friends And Family
                            </span>
                        </h3>
                        <p class="para">
                            Our community consists of individuals you know and trust, ensuring that the information you
                            receive is reputable and unbiased. No more relying on anonymous sources or second-hand
                            accounts.
                            With us, you can connect with like-minded friends and family who share their authentic
                            experiences, helping you plan your trips with confidence.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="contact-foam py">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="sectionOneContent text-center">
                        <h1 class="heading-1 bottombutton">
                            Contact Us
                        </h1>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="foam-left-side">
                        <form>
                            <div class="form-row">
                                <div class="input-group mb-3 col-6">
                                    <input type="text" class="form-control" placeholder="Name*" aria-label="Username"
                                        aria-describedby="basic-addon1">
                                </div>
                                <div class="input-group mb-3 col-6">
                                    <input type="text" class="form-control" placeholder="Email*" aria-label="Username"
                                        aria-describedby="basic-addon1">
                                </div>
                            </div>
                            <div class="form-group">

                                <textarea class="form-control" id="exampleFormControlTextarea1"
                                    placeholder="Your Message*" rows="3"></textarea>
                            </div>
                            <div class="btn-Foam">
                                <button type="submit" class="btn custom-btn pink">SEND MESSAGE</button>
                            </div>
                        </form>
                    </div>
                </div>
                <!--<div class="col-lg-6">-->
                <!--    <div class="Main-Location-Detail">-->
                <!--        <div class="Location" data-aos="fade-left">-->
                <!--            <img src="images/location-1.png" class="img-fluid" alt="">-->
                <!--            <h4>Location</h4>-->
                <!--            <p><a href="#">824 Bel Meadow Drive,-->
                <!--                    <span>California, USA</span></a></p>-->
                <!--        </div>-->
                <!--        <div class="Location" data-aos="fade-right">-->
                <!--            <img src="images/location-2.png" class="img-fluid" alt="">-->
                <!--            <h4>Phone</h4>-->
                <!--            <p>-->
                <!--                <a href="tel:+(00) 236 558 9977">+(00) 236 558 9977</a>-->
                <!--                <a href="tel:+(00) 236 558 9966">+(00) 236 558 9966</a>-->
                <!--            </p>-->

                <!--        </div>-->
                <!--    </div>-->
                <!--    <div class="Main-Location-Detail">-->
                <!--        <div class="Location" data-aos="fade-left">-->
                <!--            <img src="images/location-3.png" class="img-fluid" alt="">-->
                <!--            <h4>Mail Address</h4>-->
                <!--            <p>-->
                <!--                <a href="mailto:Info@business.Com">Info@business.Com</a>-->
                <!--                <a href="mailto:Support@business.Com">Support@business.Com</a>-->
                <!--            </p>-->

                <!--        </div>-->
                <!--        <div class="Location" data-aos="fade-right">-->
                <!--            <img src="images/location-4.png" class="img-fluid" alt="">-->
                <!--            <h4>Working Hours</h4>-->
                <!--            <p><a href="#">Mon - Fri : 9:00 am to 7:00 pm-->
                <!--                    <span>Sat : 9:00 am to 3:00 pm</span></a></p>-->
                <!--        </div>-->
                <!--    </div>-->
                <!--</div>-->
            </div>
        </div>
    </section>

    <div class="Bottom-footer px">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="MainMEnuDiv">
                        <div class="AllRightReserved">
                            <p>© 2023 All rights reserved.</p>
                        </div>
                        <div class="Footer-Menu">
                            <ul>
                                <li><a href="index.php">Home</a></li>
                                <li><a href="javascript:;">About</a></li>
                                <li><a href="javascript:;">Services </a></li>
                                <li><a href="javascript:;">Privacy Policy </a></li>
                                <li><a href="javascript:;">Terms &amp; Conditions</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!-- Optional JavaScript -->
    <!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"
        integrity="sha512-v2CJ7UaYy4JwqLDIrZUI/4hqeoQieOmAZNXBeQyjo21dadnwR+8ZaIJVT8EE2iyI61OV8e6M8PP2/4hpQINQ/g=="
        crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <!-- Option 1: Bootstrap Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM"
        crossorigin="anonymous"></script>
    <!-- moving letters  -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/animejs/2.0.2/anime.min.js"></script>
    <!-- lax cdn  -->
    <script src="https://cdn.jsdelivr.net/npm/lax.js"></script>
    <!-- data aos  -->
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

    <!-- custom js  -->
    <script src="js/custom.js"></script>

    <script>
        AOS.init();
    </script>

</body>

</html>