@extends('layouts.main')
@section('css')
<style>
    .icon button {
        outline: none;
        background: transparent;
        border: none;
    }
    .nav-item a {
    color: #8e8e95 !important;
    font-weight: 400;
}
</style>
@endsection
@section('content')
<section class="home-sec1">
    <div class="container-fluid">
        <div class="row">
<!--Recent Post-->
            @include('account.post')
            <div class="col-lg-6">
                <div class="center-bar">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" id="my-trips-tab"  href="{{route('account')}}"  >Back To Home</a>
                            </li>
                    </ul>
                </div>
                <div class="chatSection">
                    <div class="chat_bar">
                        @if($user->profile->pic != '')
                            <img src="{{asset($user->profile->pic)}}" class="user_chatImg" alt="">
                        @else
                            <img src="{{asset('images/userImage.jpg')}}"  class="user_chatImg" alt="">
                        @endif
                        
                        <div class="chat_user">
                            <h6>{{$user->name}}</h6>
                            <p>
                               @if( $user->isOnline() ) 
                                    <span>online</span> 
                                @else 
                                    <span>offline</span> 
                                @endif 
                           
                            </p>
                        </div>
                    </div>
                        
                 
                    
                    <!--CHECHKIG-->
                    
                    <div class="chattingTwo">
                        @foreach($messages as $key => $value)
                            
                            @if($value->sender_id == $user->id && $value->reciever_id == Auth::user()->id)
                                @php
                                    
                                    $userImg = App\User::where('id',$user->id)->first();
                                    
                                    $createdDate = Carbon\Carbon::parse($value->created_at);
                                    
                                    
                                    $timeWithAMPM = $createdDate->format('h:i A');
                                @endphp
                            <div class="chat">
                                <div class="chatOne">
                                    <img src="{{ $userImg->profile->pic != null ? asset($userImg->profile->pic) : asset('images/userImage.jpg') }}" width="75px" alt="">
                                    <p>{{$value->message}}</p>
                                </div>
                                <div class="check_status"> 
                                    <span > <img  src="{{asset('images/check.png')}}" class="img-fluid" alt="">
                                        {{$timeWithAMPM}}</span>
                                </div>
                            </div>
                            @elseif($value->sender_id == Auth::user()->id && $value->reciever_id == $user->id)
                            @php
                                
                                $userImg = App\User::where('id',Auth::user()->id )->first();
                                
                                $createdDate = Carbon\Carbon::parse($value->created_at);
                                
                                
                                $timeWithAMPM = $createdDate->format('h:i A');
                            @endphp
                            <div class="userchatTwo">

                                <p>{{$value->message}}</p>
                                <img src="{{ $userImg->profile->pic != null ? asset($userImg->profile->pic) : asset('images/userImage.jpg') }}" class="img-fluid" alt="">
                            </div>
                            <div class="check_status_two">
                                <span class="short_mesg"> <img src="{{asset('images/check.png')}}"  alt="">
                                    {{$timeWithAMPM}}</span>
                            </div>
                            @endif
                        @endforeach
                    </div>

                    
                    <!--CHECKING END-->
                   


                    <div class="in">
                    <form id="send-message" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="reciever_id" class="reciever_id" value="{{$user->id}}"/>
                        <input type="hidden" name="sender_id" class="sender_id" value="{{Auth::user()->id}}"/>
                        <div class="dis">
                            <div class="writ">
                            @if(Auth::user()->profile->pic)
                            <img src="{{asset(Auth::user()->profile->pic)}}" width="40px" height="40px" class="img-fluid">
                            @else
                            <img src="{{asset('images/userImage.jpg')}}" width="40px" height="40px" class="img-fluid">
                            @endif
                        <input type="text" name="comment" class="comment" placeholder="Write your message">
                        </div>
                        <div class="icon">
                            <ul>
                                <!--<li>-->
                                <!--    <a href="#"><i class="fas fa-paperclip fa-md mr-2"></i></a>-->
                                <!--</li>-->
                                <!--<li><a href="#"><i class="fa-solid fa-microphone"></i></a></li>-->
                                <!--<li> <a href="#"><i class="fa-solid fa-face-smile"></i></a></li>-->
                                <li> <button type="button" id="submitMessage"><i class="fa-solid fa-paper-plane jsahd"></i></button></li>
                            </ul>
                        </div>
                        </div>
                    </form>
                    </div>
                </div>
            </div>

            <!--Online Friend-->
            @include('account.friends')
        </div>
    </div>
</section>
@endsection
@section('js')
<script>

    $('#submitMessage').click(function(){
          var reciverId = $(this).parent().parent().parent().parent().parent().find('.reciever_id').val();
          var comment =  $(this).parent().parent().parent().parent().parent().find('.comment').val();
          var csrfToken = $('meta[name="csrf-token"]').attr('content');
          var e = this;
          console.log(comment);
          $.ajax({
            url: "{{ route('messagePost')}}",
            type:"POST",
            data: {
	            "_token": csrfToken,
	            reciverId: reciverId,
	            comment: comment,
	        },
            headers: {
                'X-CSRF-TOKEN': csrfToken
            },
            success:function(response){
                if(response.status){
                    console.log(response);
                    var img = response.user['pic'];
                    if(img === null){
                        img = 'images/userImage.jpg';
                    }
                    const currentTime = new Date();
                    const hours = currentTime.getHours();
                    const minutes = currentTime.getMinutes();
                    const ampm = hours >= 12 ? 'PM' : 'AM';
                    
                    // Convert to 12-hour format
                    const hours12 = hours % 12 || 12;
                    
                    const formattedTime = `${hours12}:${minutes < 10 ? '0' : ''}${minutes} ${ampm}`;
                    console.log(formattedTime);
                    const publicPath = '{{route("home")}}';
                    var userImg = `${publicPath}/${img}` ;
                    $(e).parent().parent().parent().parent().parent().find('.comment').val('');
                   $('.chattingTwo').append('<div class="userchatTwo"><p>'+response.message+'</p> <img src="'+userImg+'" class="img-fluid" alt=""> </div><div class="check_status_two"><span class="short_mesg"> <img src="images/check.png"  alt="">'+formattedTime+'</span></div>')
                }else{
                    console.log(response.message);
                    
                }
                
            },
            error: function (err) {
                if (err.status == 422) { // when status code is 422, it's a validation issue
                
                toastr.error(err.responseJSON.message);
                
                }
            }
        });
    });
</script>
@endsection